/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.admin.nation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandAdminNationDisband
extends KingdomsCommand {
    public CommandAdminNationDisband(KingdomsParentCommand parent) {
        super("disband", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.requireArgs(1)) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        Nation nation = Nation.getNation(args[0]);
        if (nation == null) {
            KingdomsLang.NOT_FOUND_NATION.sendMessage(sender);
            return;
        }
        if (nation.triggerDisbandEvent(GroupDisband.Reason.ADMIN).isCancelled()) {
            return;
        }
        KingdomsLang.COMMAND_ADMIN_NATION_DISBAND_SUCCESS.sendMessage(sender, "nation", nation.getName());
        if ((args.length == 1 || !args[1].equalsIgnoreCase("silent")) && KingdomsConfig.DISBAND_ANNOUNCE.getBoolean()) {
            for (Player players : Bukkit.getOnlinePlayers()) {
                KingdomsLang.COMMAND_ADMIN_NATION_DISBAND_ANNOUNCE.sendMessage((CommandSender)players, "player", sender.getName(), "nation", nation.getName());
            }
        }
        nation.disband(null);
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return TabCompleteManager.getNations(args[0]);
        }
        if (args.length == 2) {
            return Collections.singletonList("silent");
        }
        return new ArrayList<String>();
    }
}

