/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.book;

import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.book.BookManager;
import org.kingdoms.managers.book.BookSession;

public class CommandBookDiscard
extends KingdomsCommand {
    public CommandBookDiscard(KingdomsParentCommand parent) {
        super("discard", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        BookSession editingChapter = BookManager.removeSession(player);
        if (editingChapter == null) {
            context.sendError(KingdomsLang.COMMAND_BOOK_DISCARD_NOTHING_TO_DISCARD, new Object[0]);
            return;
        }
        int slot = editingChapter.getSlot();
        ItemStack book = player.getInventory().getItem(slot);
        BookMeta meta = (BookMeta)book.getItemMeta();
        context.sendMessage(KingdomsLang.COMMAND_BOOK_DISCARD_DISCARDED, "chapter", meta.getTitle());
        player.getInventory().setItem(slot, null);
    }
}

