/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.claims;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.ConfigHover;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.RangesKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.MessagePiece;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.RomanNumber;
import org.kingdoms.utils.string.tree.StringTree;
import org.kingdoms.utils.string.tree.TreeBuilder;
import org.kingdoms.utils.string.tree.TreeColorScheme;
import org.kingdoms.utils.string.tree.TreeStyle;
import org.kingdoms.utils.string.tree.TreeTokenType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/kingdoms/commands/general/claims/CommandClaimList;", "Lorg/kingdoms/commands/KingdomsCommand;", "parent", "Lorg/kingdoms/commands/KingdomsParentCommand;", "(Lorg/kingdoms/commands/KingdomsParentCommand;)V", "executeX", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "Companion", "core"})
public final class CommandClaimList
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final MessageCompilerSettings COMPILER_SETTINGS;

    public CommandClaimList(@NotNull KingdomsParentCommand parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super("list", parent);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CommandResult executeX(@NotNull CommandContext context) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = context.getKingdom();
        Map mappedLands = new HashMap();
        for (SimpleChunkLocation location : kingdom.getLandLocations()) {
            mappedLands.compute(location.getWorld(), (arg_0, arg_1) -> CommandClaimList.executeX$lambda-0(location, arg_0, arg_1));
        }
        if (mappedLands.isEmpty()) {
            context.sendError(KingdomsLang.COMMAND_CLAIM_LIST_NO_CLAIMS, new Object[0]);
            return CommandResult.FAILED;
        }
        Comparator comparator = ((Comparator)CommandClaimList::executeX$lambda-1).thenComparing(CommandClaimList::executeX$lambda-2);
        boolean allowTp = context.hasPermission(KingdomsPluginPermission.TELEPORT_TO_CLAIMS);
        KingdomsLang description = allowTp ? KingdomsLang.COMMAND_CLAIM_LIST_TELEPORT_ADMIN_DESCRIPTION : KingdomsLang.COMMAND_CLAIM_LIST_TELEPORT_DESCRIPTION;
        Iterable $this$associate$iv = mappedLands.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            MessageObject messageObject = LocationUtils.translateWorld((String)it.getKey()).getProvider(context.getSettings().getLanguage()).getMessage();
            Intrinsics.checkNotNull((Object)messageObject);
            Pair pair = TuplesKt.to((Object)messageObject.buildPlain(context.getSettings()), ((List)it.getValue()).stream().sorted(comparator).map(arg_0 -> CommandClaimList.executeX$lambda-4$lambda-3(allowTp, description, context, arg_0)).collect(Collectors.toList()));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map tree = destination$iv$iv;
        for (StringBuilder line : new TreeBuilder(tree).parse(Companion.generateTreeStyle()).print().getLines()) {
            context.sendMessage(new StaticMessenger(new MessageProvider(MessageCompiler.compile(line.toString(), COMPILER_SETTINGS))), new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    private static final List executeX$lambda-0(SimpleChunkLocation $location, String string, List v) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
        List list2 = v;
        if (list2 == null) {
            list2 = new ArrayList();
        }
        List list3 = list2;
        Intrinsics.checkNotNullExpressionValue((Object)$location, (String)"location");
        list3.add($location);
        return list3;
    }

    private static final int executeX$lambda-1(SimpleChunkLocation o1, SimpleChunkLocation o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return Intrinsics.compare((int)o1.getX(), (int)o2.getX());
    }

    private static final int executeX$lambda-2(SimpleChunkLocation o1, SimpleChunkLocation o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return Intrinsics.compare((int)o1.getZ(), (int)o2.getZ());
    }

    private static final String executeX$lambda-4$lambda-3(boolean $allowTp, KingdomsLang $description, CommandContext $context, SimpleChunkLocation land) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$description, (String)"$description");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Land land2 = land.getLand();
        Intrinsics.checkNotNull((Object)land2);
        Land landData = land2;
        int turrets = landData.getTurrets().size();
        if (landData.getStructures().size() != 1) {
            object = landData.getStructures().size();
        } else {
            Structure structure = (Structure)CollectionsKt.first((Iterable)landData.getStructures().values());
            object = structure.getDisplayName() + " {$sep}({$s}" + RomanNumber.toRoman(structure.getLevel()) + "{$sep})";
        }
        Integer structures = object;
        String str = land.getX() + "&7, {$p}" + land.getZ();
        String action = $allowTp ? "/k admin land " + land.getWorld() + ' ' + land.getX() + ' ' + land.getZ() : "";
        Object[] objectArray = new Object[]{"turrets", turrets, "structures", structures};
        String string = new ConfigHover(str, $description.parse($context.getSender(), objectArray), action).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ConfigHover(\n           \u2026             ).toString()");
        str = string;
        return str;
    }

    static {
        MessageCompilerSettings messageCompilerSettings = MessageCompilerSettings.none().colorize().translatePlaceholders().hovers();
        Intrinsics.checkNotNullExpressionValue((Object)messageCompilerSettings, (String)"none().colorize().translatePlaceholders().hovers()");
        COMPILER_SETTINGS = messageCompilerSettings;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/commands/general/claims/CommandClaimList$Companion;", "", "()V", "COMPILER_SETTINGS", "Lorg/kingdoms/locale/compiler/MessageCompilerSettings;", "generateTreeStyle", "Lorg/kingdoms/utils/string/tree/TreeStyle;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TreeStyle generateTreeStyle() {
            Object object = new EnumMap<TreeColorScheme, String>(TreeColorScheme.class);
            EnumMap<TreeColorScheme, String> $this$generateTreeStyle_u24lambda_u2d0 = object;
            boolean bl = false;
            $this$generateTreeStyle_u24lambda_u2d0.put((TreeColorScheme)((Enum)TreeColorScheme.INDICATORS), "{$sep}");
            $this$generateTreeStyle_u24lambda_u2d0.put((TreeColorScheme)((Enum)TreeColorScheme.PATH_SEPARATORS), "{$sep}");
            $this$generateTreeStyle_u24lambda_u2d0.put((TreeColorScheme)((Enum)TreeColorScheme.ENTRIES), "{$p}");
            Map<TreeColorScheme, String> colorSet = Collections.unmodifiableMap((Map)object);
            Map<TreeTokenType, String> map = StringTree.Companion.getUTF_CHARACTER_SET();
            Intrinsics.checkNotNullExpressionValue(colorSet, (String)"colorSet");
            Object $this$generateTreeStyle_u24lambda_u2d5 = object = new TreeStyle(map, colorSet);
            boolean bl2 = false;
            ((TreeStyle)$this$generateTreeStyle_u24lambda_u2d5).setFlatten(false);
            ((TreeStyle)$this$generateTreeStyle_u24lambda_u2d5).setIndentation(1);
            ((TreeStyle)$this$generateTreeStyle_u24lambda_u2d5).setMaxColumns(4);
            ((TreeStyle)$this$generateTreeStyle_u24lambda_u2d5).setColumizeFromLevel(1);
            ((TreeStyle)$this$generateTreeStyle_u24lambda_u2d5).setColumnSpaceModifier(Companion::generateTreeStyle$lambda-5$lambda-3);
            ((TreeStyle)$this$generateTreeStyle_u24lambda_u2d5).setEntryModifier(Companion::generateTreeStyle$lambda-5$lambda-4);
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private static final Integer generateTreeStyle$lambda-5$lambda-3(String line) {
            MessagePiece[] messagePieceArray = MessageCompiler.compile(line, COMPILER_SETTINGS).getPieces();
            Intrinsics.checkNotNullExpressionValue((Object)messagePieceArray, (String)"compile(line, COMPILER_SETTINGS).pieces");
            Object[] objectArray = messagePieceArray;
            int n = 0;
            for (Object object : objectArray) {
                int n2;
                void x;
                MessagePiece messagePiece = (MessagePiece)object;
                int n3 = n;
                boolean bl = false;
                void var9_8 = x;
                if (var9_8 instanceof MessagePiece.Plain) {
                    n2 = x.length();
                } else if (var9_8 instanceof MessagePiece.Hover) {
                    void $this$filterIsInstanceTo$iv$iv;
                    MessagePiece[] messagePieceArray2 = ((MessagePiece.Hover)x).getNormalMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)messagePieceArray2, (String)"x.normalMessage");
                    Object[] $this$filterIsInstance$iv = messagePieceArray2;
                    boolean $i$f$filterIsInstance = false;
                    Object[] objectArray2 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo2 = false;
                    for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof MessagePiece.Plain)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable iterable = (List)destination$iv$iv;
                    int n4 = 0;
                    for (Object e : iterable) {
                        void h;
                        MessagePiece.Plain $i$f$filterIsInstanceTo2 = (MessagePiece.Plain)e;
                        int n5 = n4;
                        boolean bl2 = false;
                        int n6 = h.length();
                        n4 = n5 + n6;
                    }
                    n2 = n4;
                } else {
                    n2 = 0;
                }
                int n7 = n2;
                n = n3 + n7;
            }
            int sum = n;
            return sum;
        }

        private static final String generateTreeStyle$lambda-5$lambda-4(Integer nestLevel, String str) {
            String string;
            Integer n;
            Integer n2 = n = nestLevel;
            int n3 = 1;
            if (n2 != null && n2 == n3) {
                string = "{$p}" + str;
            } else {
                Integer n4 = n;
                n3 = 2;
                string = n4 != null && n4 == n3 ? ' ' + str : str;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

