/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;

public class CommandBank
extends KingdomsCommand {
    public CommandBank() {
        super("bank", true);
    }

    @Override
    public void execute(CommandContext context) {
        double amount;
        if (ServiceHandler.bankServiceNotAvailable(context.getSender())) {
            return;
        }
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(2)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        String[] args = context.args;
        CommandSender sender = context.getSender();
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        try {
            amount = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException ignored) {
            KingdomsLang.INVALID_NUMBER.sendError((CommandSender)player, "arg", args[1], "needed", "money");
            return;
        }
        if (amount == 0.0) {
            KingdomsLang.COMMAND_BANK_ZERO.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (amount < 0.0) {
            KingdomsLang.COMMAND_BANK_NEGATIVE.sendError((CommandSender)player, new Object[0]);
            return;
        }
        String type = args[0].toLowerCase(Locale.ENGLISH);
        if (type.equalsIgnoreCase("withdraw")) {
            if (!kp.hasPermission(StandardKingdomPermission.WITHDRAW)) {
                StandardKingdomPermission.WITHDRAW.sendDeniedMessage(player);
                return;
            }
            if (!KingdomsConfig.ECONOMY_BANK_WITHDRAW_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_BANK_WITHDRAW_DISABLED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            double minAmount = KingdomsConfig.ECONOMY_BANK_WITHDRAW_MIN.getDouble();
            if (amount < minAmount) {
                KingdomsLang.COMMAND_BANK_WITHDRAW_MIN.sendError((CommandSender)player, "min", minAmount);
                return;
            }
            if (kingdom.getBank() < amount) {
                KingdomsLang.COMMAND_BANK_NOT_ENOUGH_KINGDOM_MONEY.sendError((CommandSender)player, "amount", amount);
                return;
            }
            kingdom.addBank(-amount);
            ServiceVault.deposit((OfflinePlayer)player, amount);
            KingdomsLang.COMMAND_BANK_WITHDRAW_SUCCESS.sendError((CommandSender)player, "amount", amount, "translated", amount, "balance", ServiceVault.getMoney((OfflinePlayer)player));
        } else if (type.equalsIgnoreCase("deposit")) {
            if (!KingdomsConfig.ECONOMY_BANK_DEPOSIT_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_BANK_DEPOSIT_DISABLED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            double minAmount = KingdomsConfig.ECONOMY_BANK_DEPOSIT_MIN.getDouble();
            if (amount < minAmount) {
                KingdomsLang.COMMAND_BANK_DEPOSIT_MIN.sendError((CommandSender)player, "min", minAmount);
                return;
            }
            if (!ServiceVault.hasMoney((OfflinePlayer)player, amount)) {
                KingdomsLang.COMMAND_BANK_NOT_ENOUGH_MONEY.sendError((CommandSender)player, "amount", amount);
                return;
            }
            double limit = KingdomsConfig.ECONOMY_BANK_LIMIT_KINGDOMS.getDouble();
            if (kingdom.getBank() + amount > limit) {
                KingdomsLang.COMMAND_BANK_DEPOSIT_LIMIT.sendError((CommandSender)player, "amount", amount, "limit", limit);
                return;
            }
            kingdom.addBank(amount);
            ServiceVault.withdraw((OfflinePlayer)player, amount);
            KingdomsLang.COMMAND_BANK_DEPOSIT_SUCCESS.sendMessage((CommandSender)player, "amount", amount, "translated", amount, "balance", ServiceVault.getMoney((OfflinePlayer)player));
        } else {
            KingdomsLang.COMMAND_BANK_UNKNOWN_TRANSACTION.sendError((CommandSender)player, "transaction", args[0]);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender instanceof Player) {
            if (args.length == 1) {
                return Arrays.asList("deposit", "withdraw");
            }
            if (args.length == 2) {
                return Collections.singletonList("<amount>");
            }
        }
        return new ArrayList<String>();
    }
}

