/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.invasions.Invasion;

public class CommandSurrender
extends KingdomsCommand {
    public CommandSurrender() {
        super("surrender", true);
    }

    public static InteractiveGUI openSurrenderGUI(Player player) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.SURRENDER);
        if (gui == null) {
            return null;
        }
        gui.option("invasion").onNormalClicks(ctx -> {
            Invasion invasion = kp.getInvasion();
            if (invasion.hasEnded()) {
                ctx.sendError(KingdomsLang.COMMAND_SURRENDER_ALREADY_ENDED, new Object[0]);
                return;
            }
            invasion.end(Invasion.Result.ATTACKER_SURRENDERED);
        }).done();
        ReusableOptionHandler attacking = gui.getReusableOption("attacking");
        ReusableOptionHandler defending = gui.getReusableOption("defending");
        for (Land land : kingdom.getLands()) {
            Invasion invasion;
            if (!land.isBeingInvaded() || (invasion = land.getInvasions().get(kingdom.getId())) == null) continue;
            defending.setSettings(invasion.getInvasionEdits());
            defending.onNormalClicks(ctx -> invasion.end(Invasion.Result.DEFENDER_SURRENDERED)).done();
        }
        for (Invasion invasion : kingdom.getInvasions().values()) {
            attacking.setSettings(invasion.getInvasionEdits());
            attacking.onNormalClicks(ctx -> invasion.end(Invasion.Result.ATTACKER_SURRENDERED)).done();
        }
        gui.open();
        return gui;
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.INVADE)) {
            context.sendError(KingdomsLang.COMMAND_SURRENDER_DEFENDER_PERMISSION, new Object[0]);
            return;
        }
        if (kp.isInvading()) {
            Invasion invasion = kp.getInvasion();
            invasion.end(Invasion.Result.ATTACKER_SURRENDERED);
        } else {
            CommandSurrender.openSurrenderGUI(player);
        }
    }
}

