/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

public class CommandTop
extends KingdomsCommand {
    public CommandTop() {
        super("top", true);
    }

    @Override
    public void execute(CommandContext context) {
        context.sendMessage(KingdomsLang.COMMAND_TOP_LOADING, new Object[0]);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> {
            int page = 1;
            if (context.assertArgs(1)) {
                Integer tempPage = context.getInt(0);
                if (tempPage == null) {
                    return;
                }
                page = tempPage;
            }
            int nextPage = page + 1;
            int previousPage = page - 1;
            Object[] edits = new Object[]{"page", page, "next_page", nextPage, "previous_page", previousPage};
            if (page - 1 < 0) {
                context.sendMessage(KingdomsLang.COMMAND_TOP_NEGATIVE, edits);
                return;
            }
            boolean showPacifists = KingdomsConfig.TOP_KINGDOMS_SHOW_PACIFISTS.getBoolean();
            int limit = KingdomsConfig.TOP_KINGDOMS_AMOUNT.getInt();
            int skip = (page - 1) * limit;
            List<Kingdom> kingdoms = KingdomsDataCenter.get().getKingdomManager().getTopKingdoms(skip, limit, showPacifists ? null : x -> !x.isPacifist());
            if (kingdoms.isEmpty()) {
                context.sendError(KingdomsLang.COMMAND_TOP_NO_MORE_PAGES, edits);
                return;
            }
            int finalPage = page;
            KLogger.debug((DebugNS)KingdomsDebug.COMMAND_TOP, () -> "Displaying top kingdoms with limit=" + limit + ", skip=" + skip + ", showPacifists=" + showPacifists + ", page=" + finalPage + ", filtered=" + kingdoms.size());
            context.sendMessage(KingdomsLang.COMMAND_TOP_HEADER, new Object[0]);
            int ranking = skip;
            for (Kingdom kingdom : kingdoms) {
                int finalRanking = ++ranking;
                KingdomsLang.COMMAND_TOP_ENTRY.sendMessage(context.getSender(), new MessageBuilder().withContext(kingdom).raws("rank", String.valueOf(finalRanking), "page", page, "next_page", nextPage, "previous_page", previousPage));
            }
            context.sendMessage(KingdomsLang.COMMAND_TOP_FOOTER, edits);
        });
    }
}

