/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.misc.chat;

import java.util.List;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandMute
extends KingdomsCommand {
    public CommandMute() {
        super("mute", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        String channelName = context.arg(0);
        KingdomsChatChannel channel = KingdomsChatChannel.getChannelUserFriendly(channelName, context.getSettings());
        context.var("channel", channelName);
        if (channel == null) {
            context.sendError(KingdomsLang.COMMAND_CHAT_UNKNOWN_CHANNEL, new Object[0]);
            return;
        }
        if (kp.getMutedChannels().contains(channel.getDataId())) {
            context.sendError(KingdomsLang.COMMAND_MUTE_ALREADY_MUTED, new Object[0]);
            return;
        }
        kp.getMutedChannels().add(channel.getDataId());
        context.sendMessage(KingdomsLang.COMMAND_MUTE_MUTED, new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (!context.isPlayer()) {
            return CommandMute.emptyTab();
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        return context.getChannels(0, x -> !kp.getMutedChannels().contains(x.getDataId()));
    }
}

