/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.nexus;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.structures.NexusManager;

public class CommandNexusOpen
extends KingdomsCommand {
    public CommandNexusOpen(@Nullable KingdomsParentCommand parent) {
        super("open", parent, PermissionDefault.OP);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendError((CommandSender)player, new Object[0]);
            return;
        }
        new NexusManager(kingdom, player).openNexus();
    }
}

