/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.nexus;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.KingdomsPluginPermission;

public class CommandNexusRemove
extends KingdomsCommand {
    public CommandNexusRemove(@Nullable KingdomsParentCommand parent) {
        super("remove", parent);
    }

    @Override
    public void execute(CommandContext context) {
        Land land;
        if (context.assertPlayer()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        if (!KingdomsConfig.NEXUS_ALLOW_REMOVAL.getBoolean() && !context.hasPermission(KingdomsPluginPermission.NEXUS_REMOVE, true)) {
            KingdomsLang.COMMAND_NEXUS_REMOVE_PERMISSION.sendMessage((CommandSender)player);
            return;
        }
        SimpleLocation nexus = kingdom.getNexus();
        if (nexus == null) {
            KingdomsLang.COMMAND_NEXUS_REMOVE_NOT_PLACED.sendMessage((CommandSender)player);
            return;
        }
        if (!kp.isAdmin() && KingdomsConfig.Invasions.ALLOW_MOVING_NEXUS.getManager().getBoolean() && (land = nexus.toSimpleChunkLocation().getLand()).isBeingInvaded()) {
            KingdomsLang.COMMAND_NEXUS_REMOVE_INVASION.sendMessage((CommandSender)player);
            return;
        }
        SimpleLocation location = kingdom.getNexus();
        Land land2 = location.toSimpleChunkLocation().getLand();
        KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
        ctx.setPlayer(kp);
        land2.getStructures().get(location).remove(ctx);
        KingdomsLang.COMMAND_NEXUS_REMOVE_REMOVED.sendMessage((CommandSender)player);
    }
}

