/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandDemote
extends KingdomsCommand {
    public CommandDemote() {
        super("demote", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer demoterKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!demoterKp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        if (!demoterKp.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
            StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(player);
            return;
        }
        OfflinePlayer promoting = context.getOfflinePlayer(0);
        if (promoting == null) {
            return;
        }
        KingdomPlayer demotingKp = KingdomPlayer.getKingdomPlayer(promoting);
        if (!demoterKp.isInSameKingdomAs(demotingKp)) {
            KingdomsLang.COMMAND_DEMOTE_NOT_IN_KINGDOM.sendError((CommandSender)player, "demoted", promoting.getName());
            return;
        }
        if (!demoterKp.getRank().isHigherThan(demotingKp.getRank())) {
            KingdomsLang.COMMAND_DEMOTE_CANT_DEMOTE.sendError((CommandSender)player, "demoted", promoting.getName());
            return;
        }
        Kingdom kingdom = demoterKp.getKingdom();
        if (kingdom.getRanks().isMemberRank(demotingKp.getRank())) {
            KingdomsLang.COMMAND_DEMOTE_MEMBER.sendError((CommandSender)player, new Object[0]);
            return;
        }
        @NonNull PlayerRankChangeEvent event = demotingKp.demote(demoterKp);
        if (event.isCancelled()) {
            return;
        }
        Rank rank = event.getRank();
        Object[] edits = new Object[]{"rank", rank.getColor() + rank.getName(), "demoted", promoting.getName()};
        for (Player member : kingdom.getOnlineMembers()) {
            KingdomsLang.COMMAND_DEMOTE_DEMOTED.sendMessage((CommandSender)member, (OfflinePlayer)player, edits);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (args.length == 1) {
                return TabCompleteManager.getKingdomPlayers(kingdom, args[0], p -> p != sender);
            }
        }
        return new ArrayList<String>();
    }
}

