/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandPromote
extends KingdomsCommand {
    public CommandPromote() {
        super("promote", true);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
            StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(player);
            return;
        }
        OfflinePlayer promoting = context.getOfflinePlayer(0);
        if (promoting == null) {
            return;
        }
        KingdomPlayer promotingKp = KingdomPlayer.getKingdomPlayer(promoting);
        if (!kp.isInSameKingdomAs(promotingKp)) {
            KingdomsLang.COMMAND_PROMOTE_NOT_IN_KINGDOM.sendError((CommandSender)player, "promoted", promoting.getName());
            return;
        }
        CommandPromote.promote(kp, promotingKp);
    }

    public static boolean promote(KingdomPlayer promoterKp, KingdomPlayer promotedKp) {
        Player promoter = promoterKp.getPlayer();
        OfflinePlayer promoting = promotedKp.getOfflinePlayer();
        Rank promotedRank = promotedKp.getRank();
        if (!promoterKp.isAdmin() && !promoterKp.getRank().isHigherThan(promotedRank)) {
            KingdomsLang.COMMAND_PROMOTE_CANT_PROMOTE.sendError((CommandSender)promoter, "promoted", promoting.getName());
            return false;
        }
        if (!promotedRank.canBePromoted()) {
            KingdomsLang.COMMAND_PROMOTE_KING.sendError((CommandSender)promoter, "promoted", promoting.getName(), "rank", promotedRank.getColor() + promotedRank.getName());
            return false;
        }
        PlayerRankChangeEvent newRankEvent = promotedKp.promote(promoterKp);
        newRankEvent.getOldRank();
        if (newRankEvent.isCancelled()) {
            return false;
        }
        Rank newRank = newRankEvent.getRank();
        for (Player member : promotedKp.getKingdom().getOnlineMembers()) {
            KingdomsLang.COMMAND_PROMOTE_PROMOTED.sendMessage((CommandSender)member, (OfflinePlayer)promoter, new Object[]{"rank", newRank.getColor() + newRank.getName(), "promoted", promoting.getName()});
        }
        return true;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (args.length == 1) {
                return TabCompleteManager.getKingdomPlayers(kingdom, args[0], p -> p != sender);
            }
        }
        return new ArrayList<String>();
    }
}

