/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.visualizer;

import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.land.indicator.LandIndicator;
import org.kingdoms.managers.land.indicator.LandVisualizer;
import org.kingdoms.managers.land.indicator.MultiLandBlockIndicator;

public class CommandVisualizeAll
extends KingdomsCommand {
    public CommandVisualizeAll(KingdomsParentCommand parent) {
        super("all", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        final Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        final Kingdom kingdom = kp.getKingdom();
        final SimpleChunkLocation masterChunk = SimpleChunkLocation.of(player.getLocation());
        final AtomicInteger chunks = new AtomicInteger();
        BukkitTask task = null;
        if (!LandVisualizer.getPermanent().contains(player.getUniqueId())) {
            task = new BukkitRunnable(){

                public void run() {
                    LandIndicator blocks = LandVisualizer.getVisualizer().remove(player.getEntityId());
                    if (blocks != null) {
                        blocks.end();
                    }
                }
            }.runTaskLater((Plugin)Kingdoms.get(), (long)KingdomsConfig.Claims.INDICATOR_VISUALIZER_ALL_STAY.getManager().getInt() * 20L);
        }
        final MultiLandBlockIndicator indicator = new MultiLandBlockIndicator(player, task);
        LandVisualizer.removeVisualizers(player, true);
        new BukkitRunnable(){

            public void run() {
                for (SimpleChunkLocation chunk : masterChunk.getChunksAround(3, true)) {
                    Land land = chunk.getLand();
                    Kingdom landsKingdom = land == null ? null : land.getKingdom();
                    indicator.append(chunk, LandVisualizer.getRelationOf(chunk, landsKingdom, kingdom));
                    chunks.incrementAndGet();
                }
            }
        }.runTaskAsynchronously((Plugin)Kingdoms.get());
        LandVisualizer.getVisualizer().put(player.getEntityId(), indicator);
        context.sendMessage(KingdomsLang.COMMAND_VISUALIZE_ALL_SHOWING, "chunks", chunks.get());
    }
}

