/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;

public class CommandNationBank
extends KingdomsCommand {
    public CommandNationBank(KingdomsParentCommand parent) {
        super("bank", parent);
    }

    @Override
    public void execute(CommandContext context) {
        if (ServiceHandler.bankServiceNotAvailable(context.getSender())) {
            return;
        }
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(2)) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return;
        }
        Kingdom kingdom = kp.getKingdom();
        Nation nation = kingdom.getNation();
        if (nation == null) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return;
        }
        Double amount = context.getDouble(1);
        if (amount == null) {
            return;
        }
        if (amount == 0.0) {
            KingdomsLang.COMMAND_NATION_BANK_ZERO.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (amount < 0.0) {
            KingdomsLang.COMMAND_NATION_BANK_NEGATIVE.sendError((CommandSender)player, new Object[0]);
            return;
        }
        String type = context.arg(0).toLowerCase(Locale.ENGLISH);
        if (type.equalsIgnoreCase("withdraw")) {
            if (!kp.hasNationPermission(StandardKingdomPermission.WITHDRAW)) {
                StandardKingdomPermission.WITHDRAW.sendDeniedMessage(player);
                return;
            }
            if (!KingdomsConfig.ECONOMY_BANK_WITHDRAW_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_NATION_BANK_WITHDRAW_DISABLED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            double minAmount = KingdomsConfig.ECONOMY_BANK_WITHDRAW_MIN.getDouble();
            if (amount < minAmount) {
                KingdomsLang.COMMAND_BANK_WITHDRAW_MIN.sendError((CommandSender)player, "min", minAmount);
                return;
            }
            if (nation.getBank() < amount) {
                KingdomsLang.COMMAND_NATION_BANK_NOT_ENOUGH_NATION_MONEY.sendMessage((CommandSender)player, "amount", amount);
                return;
            }
            nation.addBank(-amount.doubleValue());
            ServiceVault.deposit((OfflinePlayer)player, amount);
            KingdomsLang.COMMAND_NATION_BANK_WITHDRAW_SUCCESS.sendMessage((CommandSender)player, "amount", amount, "translated", amount, "balance", ServiceVault.getMoney((OfflinePlayer)player));
        } else if (type.equalsIgnoreCase("deposit")) {
            if (!KingdomsConfig.ECONOMY_BANK_DEPOSIT_ENABLED.getBoolean()) {
                KingdomsLang.COMMAND_NATION_BANK_DEPOSIT_DISABLED.sendMessage((CommandSender)player);
                return;
            }
            double minAmount = KingdomsConfig.ECONOMY_BANK_DEPOSIT_MIN.getDouble();
            if (amount < minAmount) {
                KingdomsLang.COMMAND_BANK_DEPOSIT_MIN.sendError((CommandSender)player, "min", minAmount);
                return;
            }
            if (!ServiceVault.hasMoney((OfflinePlayer)player, amount)) {
                KingdomsLang.COMMAND_NATION_BANK_NOT_ENOUGH_MONEY.sendMessage((CommandSender)player, "amount", amount);
                return;
            }
            double limit = KingdomsConfig.ECONOMY_BANK_LIMIT_NATIONS.getDouble();
            if (nation.getBank() + amount > limit) {
                KingdomsLang.COMMAND_BANK_DEPOSIT_LIMIT.sendMessage((CommandSender)player, "amount", amount, "limit", limit);
                return;
            }
            nation.addBank(amount);
            ServiceVault.withdraw((OfflinePlayer)player, amount);
            KingdomsLang.COMMAND_NATION_BANK_DEPOSIT_SUCCESS.sendMessage((CommandSender)player, "amount", amount, "translated", amount, "balance", ServiceVault.getMoney((OfflinePlayer)player));
        } else {
            KingdomsLang.COMMAND_NATION_BANK_UNKNOWN_TRANSACTION.sendMessage((CommandSender)player, "transaction", type);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1) {
            return Arrays.asList("deposit", "withdraw");
        }
        if (args.length == 2) {
            return Collections.singletonList("<amount>");
        }
        return new ArrayList<String>();
    }
}

