/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationPromote
extends KingdomsCommand {
    public CommandNationPromote(KingdomsParentCommand parent) {
        super("promote", parent, PermissionDefault.TRUE);
    }

    @Override
    public void execute(CommandContext context) {
        if (context.assertPlayer()) {
            return;
        }
        if (context.requireArgs(1)) {
            return;
        }
        if (context.assertHasKingdom()) {
            return;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        Nation nation = kingdom.getNation();
        if (nation == null) {
            KingdomsLang.NO_NATION.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (!kp.hasNationPermission(StandardKingdomPermission.MANAGE_RANKS)) {
            StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(player);
            return;
        }
        Player promoting = context.getPlayer(0);
        if (promoting == null) {
            return;
        }
        KingdomPlayer promotingKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)promoting);
        Kingdom promotingKingdom = promotingKp.getKingdom();
        if (!kingdom.isInSameNationAs(promotingKingdom)) {
            KingdomsLang.COMMAND_NATION_PROMOTE_NOT_IN_KINGDOM.sendError((CommandSender)player, "promoted", promoting.getName());
            return;
        }
        Rank rank = promotingKp.getNationRank();
        if (!kp.getNationRank().isHigherThan(rank)) {
            KingdomsLang.COMMAND_NATION_PROMOTE_CANT_PROMOTE.sendError((CommandSender)player, "promoted", promoting.getName());
            return;
        }
        if (rank.isKing()) {
            KingdomsLang.COMMAND_NATION_PROMOTE_KING.sendError((CommandSender)player, new Object[0]);
            return;
        }
        if (rank.canBePromoted()) {
            KingdomsLang.COMMAND_NATION_PROMOTE_TO_BE_KING.sendError((CommandSender)player, "promoted", promoting.getName(), "rank", rank.getColor() + rank.getName());
            return;
        }
        if (promotingKp.promoteNation().isCancelled()) {
            return;
        }
        context.getSettings().withContext(player).parse("rank", rank.getColor() + rank.getName()).parse("promoted", promoting.getName());
        for (Player member : kingdom.getOnlineMembers()) {
            context.sendMessage((CommandSender)member, KingdomsLang.COMMAND_NATION_PROMOTE_PROMOTED, new Object[0]);
        }
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandSender sender, @NonNull String[] args) {
        if (args.length == 1 && sender instanceof Player) {
            Player player = (Player)sender;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (!kp.hasNationPermission(StandardKingdomPermission.MANAGE_RANKS)) {
                return Collections.singletonList(StandardKingdomPermission.MANAGE_RANKS.getDeniedMessage().parse(player, new Object[0]));
            }
            Nation nation = kingdom.getNation();
            if (nation == null) {
                return Collections.singletonList(KingdomsLang.NO_NATION.parse(player, new Object[0]));
            }
            return TabCompleteManager.getKingdomPlayers(kingdom, args[0], p -> player != p);
        }
        return new ArrayList<String>();
    }
}

