/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config.migration;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.kingdoms.config.migration.ConfigMigration;
import org.kingdoms.config.migration.ConfigMigrationSession;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.Regex;
import org.kingdoms.utils.config.adapters.YamlContainer;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/config/migration/SoftwareWideConfigReplacer;", "Lorg/kingdoms/config/migration/ConfigMigration;", "replace", "Lorg/kingdoms/libs/kotlin/text/Regex;", "with", "", "(Lkotlin/text/Regex;Ljava/lang/String;)V", "priority", "", "getPriority", "()I", "apply", "", "session", "Lorg/kingdoms/config/migration/ConfigMigrationSession;", "core"})
public final class SoftwareWideConfigReplacer
extends ConfigMigration {
    @NotNull
    private final Regex replace;
    @NotNull
    private final String with;
    private final int priority;

    public SoftwareWideConfigReplacer(@NotNull Regex replace, @NotNull String with) {
        Intrinsics.checkNotNullParameter((Object)replace, (String)"replace");
        Intrinsics.checkNotNullParameter((Object)with, (String)"with");
        this.replace = replace;
        this.with = with;
        this.priority = 1;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void apply(@NotNull ConfigMigrationSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        for (YamlContainer config : session.getConfigs()) {
            byte[] byArray;
            if (session.getDeletedConfigs().contains(config)) continue;
            Path path = config.getFile().toPath();
            Charset charSet = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)Files.readAllBytes(path), (String)"readAllBytes(path)");
            Intrinsics.checkNotNullExpressionValue((Object)charSet, (String)"charSet");
            Object object = charSet;
            String oldContent = new String(byArray, (Charset)object);
            Regex regex = this.replace;
            String string = this.with;
            String newContent = regex.replace((CharSequence)(object = (CharSequence)oldContent), string);
            if (Intrinsics.areEqual((Object)oldContent, (Object)newContent)) continue;
            byte[] byArray2 = newContent.getBytes(charSet);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
            Files.write(path, byArray2, new OpenOption[0]);
            session.getConfigsNeedingReload().add(config);
        }
    }
}

