/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.util.UUID;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;

@FunctionalInterface
public interface GroupResolver {
    public static final KingdomsResolver KINGDOMS_RESOLVER = new KingdomsResolver();
    public static final NationResolver NATION_RESOLVER = new NationResolver();

    public Group getGroup(UUID var1);

    public static class KingdomsResolver
    implements GroupResolver {
        private KingdomsResolver() {
        }

        @Override
        public Group getGroup(UUID id) {
            return Kingdom.getKingdom(id);
        }
    }

    public static class NationResolver
    implements GroupResolver {
        private NationResolver() {
        }

        @Override
        public Group getGroup(UUID id) {
            return Nation.getNation(id);
        }
    }
}

