/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs;

import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.time.TimeUtils;

public abstract class AuditLog {
    private long time = System.currentTimeMillis();

    public abstract AuditLogProvider getProvider();

    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        this.time = context.getDataProvider().get("time").asLong();
    }

    public void serialize(SerializationContext<SectionableDataSetter> context) {
        context.getDataProvider().setLong("time", this.time);
    }

    public final long getTime() {
        return this.time;
    }

    public final MessageBuilder getEdits() {
        MessageBuilder edits = new MessageBuilder();
        this.addEdits(edits);
        return edits;
    }

    public void addEdits(MessageBuilder builder) {
        builder.raw("time", TimeUtils.getDateAndTime(this.time).toString());
    }
}

