/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import com.google.common.base.Enums;
import java.util.UUID;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.locale.provider.MessageBuilder;

public class LogKingdomLeave
extends LogPlayerOperator {
    private LeaveReason reason;
    private static final Namespace NS = Namespace.kingdoms("KINGDOM_LEAVE");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogKingdomLeave();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogKingdomLeave() {
    }

    public LogKingdomLeave(UUID player, LeaveReason reason) {
        super(player);
        this.reason = reason;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.reason = (LeaveReason)((Object)Enums.getIfPresent(LeaveReason.class, (String)json.get("reason").asString()).orNull());
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setString("reason", this.reason.name());
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.raw("reason", this.reason.name());
    }

    public LeaveReason getReason() {
        return this.reason;
    }
}

