/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.internal.FastUUID;

public class LogKingdomResourcePointsConvert
extends AuditLog {
    private UUID player;
    private long amountBefore;
    private long amountAfter;
    private static final Namespace NS = Namespace.kingdoms("KINGDOM_RESOURCE_POINTS_CONVERT");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogKingdomResourcePointsConvert();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogKingdomResourcePointsConvert() {
    }

    public LogKingdomResourcePointsConvert(UUID player, long amountBefore, long amountAfter) {
        this.player = player;
        this.amountBefore = amountBefore;
        this.amountAfter = amountAfter;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.player = FastUUID.fromString(json.get("player").asString());
        this.amountBefore = json.get("amountBefore").asLong();
        this.amountAfter = json.get("amountAfter").asLong();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("player", this.player);
        json.setLong("amountBefore", this.amountBefore);
        json.setLong("amountAfter", this.amountAfter);
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.withContext(this.getPlayer());
        builder.raw("amount-before", this.amountBefore);
        builder.raw("amount-after", this.amountAfter);
    }

    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.player);
    }
}

