/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.LocationUtils;

public class LogNexusMove
extends LogPlayerOperator {
    private SimpleLocation from;
    private SimpleLocation to;
    private static final Namespace NS = Namespace.kingdoms("STRUCTURES_NEXUS_MOVE");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogNexusMove();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogNexusMove() {
    }

    public LogNexusMove(UUID player, SimpleLocation from, SimpleLocation to) {
        super(player);
        this.from = from;
        this.to = to;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        String from = json.getString("from");
        if (from != null) {
            this.from = SimpleLocation.fromString(from);
        }
        this.to = SimpleLocation.fromString(json.get("to").asString());
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        if (this.from != null) {
            json.setString("from", this.from.toString());
        }
        json.setString("to", this.to.toString());
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        builder.raw("placed", this.from == null);
        if (this.from != null) {
            builder.addAll(LocationUtils.getLocationEdits(this.from, "from_"));
        }
        builder.addAll(LocationUtils.getLocationEdits(this.to, "to_"));
    }
}

