/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.ranks;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.misc.LogPlayerOperator;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;

public class LogPlayerRankChange
extends LogPlayerOperator {
    private String oldRankNode;
    private String newRankNode;
    private int oldRankPriority;
    private int newRankPriority;
    private String oldRank;
    private String newRank;
    private UUID byPlayer;
    private static final Namespace NS = Namespace.kingdoms("PLAYER_RANK_CHANGE");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogPlayerRankChange();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogPlayerRankChange() {
    }

    public LogPlayerRankChange(KingdomPlayer kp, Rank oldRank, Rank newRank, UUID byPlayer) {
        super(kp.getId());
        this.byPlayer = byPlayer;
        this.oldRank = oldRank.getColor() + oldRank.getSymbol() + ' ' + oldRank.getName();
        this.newRank = newRank.getColor() + newRank.getSymbol() + ' ' + newRank.getName();
        this.oldRankNode = oldRank.getNode();
        this.newRankNode = newRank.getNode();
        this.oldRankPriority = oldRank.getPriority();
        this.newRankPriority = newRank.getPriority();
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.byPlayer = json.get("byPlayer").asUUID();
        this.oldRankNode = json.get("oldRankNode").asString();
        this.newRankNode = json.get("newRankNode").asString();
        this.oldRank = json.get("oldRank").asString();
        this.newRank = json.get("newRank").asString();
        this.oldRankPriority = json.get("oldRankPriority").asInt();
        this.newRankPriority = json.get("newRankPriority").asInt();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setString("oldRankNode", this.oldRankNode);
        json.setString("newRankNode", this.newRankNode);
        json.setString("oldRank", this.oldRank);
        json.setString("newRank", this.newRank);
        json.setInt("oldRankPriority", this.oldRankPriority);
        json.setInt("newRankPriority", this.newRankPriority);
        json.setUUID("byPlayer", this.byPlayer);
    }

    @Override
    public void addEdits(MessageBuilder builder) {
        super.addEdits(builder);
        if (this.byPlayer != null) {
            builder.raw("by-player", Bukkit.getOfflinePlayer((UUID)this.byPlayer).getName());
        } else {
            builder.raw("by-player", KingdomsLang.UNKNOWN);
        }
        builder.raw("old-rank-node", this.oldRankNode);
        builder.raw("new-rank-node", this.newRankNode);
        builder.parse("old-rank", this.oldRank);
        builder.parse("new-rank", this.newRank);
        builder.raw("old_rank_priority", this.oldRankPriority);
        builder.raw("new_rank_priority", this.newRankPriority);
    }
}

