/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable.champion;

import org.kingdoms.config.EnumConfig;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.constants.group.upgradable.StandardKingdomUpgrade;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.utils.string.StringUtils;

public enum ChampionUpgrade implements StandardKingdomUpgrade
{
    REINFORCEMENTS,
    RESISTANCE,
    DEATH_DUEL,
    DAMAGE_CAP,
    STRENGTH,
    EQUIPMENT,
    HEALTH,
    FOCUS,
    THROW,
    SPEED,
    DRAG,
    THOR,
    FANGS,
    PLOW;

    public static final ChampionUpgrade[] VALUES;

    @Override
    public String getDataName() {
        return this.name();
    }

    public String toString() {
        return StringUtils.capitalize(this.name());
    }

    public KeyedYamlConfigAccessor getOption(String name) {
        return KingdomsConfig.ChampionUpgrades.SCALING.getManager().withOption("upgrade", StringUtils.configOption(this)).withOption("scaling", name);
    }

    @Override
    public EnumConfig getEnabledOption() {
        return KingdomsConfig.ChampionUpgrades.ENABLED;
    }

    @Override
    public EnumConfig getScalingOption() {
        return KingdomsConfig.ChampionUpgrades.SCALING.getManager().withOption("scaling", "scaling");
    }

    @Override
    public EnumConfig getUpgradeCostOption() {
        return KingdomsConfig.ChampionUpgrades.COST;
    }

    @Override
    public EnumConfig getMaxLevelOption() {
        return KingdomsConfig.ChampionUpgrades.MAX_LEVEL;
    }

    @Override
    public EnumConfig getDefaultLevelOption() {
        return KingdomsConfig.ChampionUpgrades.DEFAULT_LEVEL;
    }

    @Override
    public LanguageEntryMessenger getDisplayName() {
        return new LanguageEntryMessenger("upgrades", "champion", StringUtils.configOption(this.name()), "name");
    }

    static {
        VALUES = ChampionUpgrade.values();
    }
}

