/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction.gui;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.managers.land.KingdomItemGUIProtection;

public class KingdomItemGUIContext<T extends KingdomItem<?>> {
    private final KingdomItemInteractEvent<T> event;
    private InteractiveGUI refresher;

    public KingdomItemGUIContext(KingdomItemInteractEvent<T> event) {
        this.event = event;
    }

    public boolean isRefreshing() {
        return this.refresher != null;
    }

    public KingdomItemGUIContext<T> refresh(InteractiveGUI gui) {
        this.refresher = gui;
        return this;
    }

    public KingdomItemInteractEvent<T> getEvent() {
        return this.event;
    }

    public void pushRenamingGUI(Structure structure, InteractiveGUI gui) {
        @Nullable Player player = this.event.getPlayer().getPlayer();
        gui.push("rename", () -> {
            KingdomsLang.STRUCTURES_ENTER_NAME.sendMessage((CommandSender)player);
            gui.startConversation("rename");
        }, input -> {
            input = MessageHandler.colorize(input);
            gui.endConversation();
            KingdomsLang.STRUCTURES_NAME_SET.sendMessage((CommandSender)player, "name", input);
            structure.setName((String)input);
            structure.updateHolograms(((KingdomItem)this.event.getKingdomItem()).getLand().getKingdom());
        }, new Object[0]);
    }

    public static void addBreakButton(KingdomItemInteractEvent<?> event, InteractiveGUI gui) {
        gui.push("break", () -> {
            StandardKingdomPermission permission;
            Player player = event.getPlayer().getPlayer();
            KingdomPlayer kp = event.getPlayer();
            boolean structure = event.getKingdomItem() instanceof Structure;
            StandardKingdomPermission standardKingdomPermission = permission = structure ? StandardKingdomPermission.STRUCTURES : StandardKingdomPermission.TURRETS;
            if (!kp.isAdmin() && kp.hasKingdom() && !kp.hasPermission(permission)) {
                permission.getDeniedMessage().sendError((CommandSender)player, new Object[0]);
                return;
            }
            KingdomItemRemoveContext ctx = new KingdomItemRemoveContext();
            ctx.setPlayer(kp);
            ctx.setCause(event);
            if (((KingdomItem)event.getKingdomItem()).remove(ctx).isCancelled()) {
                return;
            }
        }, new Object[0]);
    }

    public static void putGUI(KingdomItemInteractEvent<?> event) {
        SimpleLocation loc = ((KingdomItem)event.getKingdomItem()).getLocation();
        Player player = event.getPlayer().getPlayer();
        KingdomItemGUIProtection.OPENED_GUI_PLAYER.put(player, loc);
        KingdomItemGUIProtection.OPENED_GUI.compute(loc, (k, list2) -> {
            if (list2 == null) {
                list2 = new CopyOnWriteArrayList<Player>();
            }
            list2.add(player);
            return list2;
        });
    }

    public void closeForOthers() {
        List viewers = KingdomItemGUIProtection.OPENED_GUI.get(((KingdomItem)this.event.getKingdomItem()).getLocation());
        if (viewers == null) {
            return;
        }
        Player player = this.event.getPlayer().getPlayer();
        for (Player viewer : viewers) {
            if (viewer.getEntityId() == player.getEntityId()) continue;
            viewer.closeInventory();
        }
    }

    public InteractiveGUI finalizeGUI(InteractiveGUI gui) {
        return this.finalizeGUI(gui, false);
    }

    public InteractiveGUI finalizeGUI(InteractiveGUI gui, boolean refresh) {
        if (gui == null) {
            return null;
        }
        if (!refresh) {
            KingdomItemGUIContext.putGUI(this.event);
        }
        KingdomItemGUIContext.addBreakButton(this.event, gui);
        if (this.event.getKingdomItem() instanceof Structure) {
            this.pushRenamingGUI((Structure)this.event.getKingdomItem(), gui);
        }
        if (refresh) {
            gui.setRemainingOptions();
            gui.getOwner().updateInventory();
        } else {
            gui.open();
        }
        return gui;
    }
}

