/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.land.structures.objects.JailStructure;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.time.TimeRange;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010&\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0014\"\u0004\b!\u0010\u0016R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006+"}, d2={"Lorg/kingdoms/constants/land/structures/JailSession;", "", "jailedPlayer", "Ljava/util/UUID;", "issuer", "jailPeriod", "Ljava/time/Duration;", "bail", "", "freeHours", "", "Lorg/kingdoms/utils/time/TimeRange;", "requiredItems", "Lorg/bukkit/inventory/ItemStack;", "(Ljava/util/UUID;Ljava/util/UUID;Ljava/time/Duration;DLjava/util/List;Ljava/util/List;)V", "getBail", "()D", "setBail", "(D)V", "getFreeHours", "()Ljava/util/List;", "setFreeHours", "(Ljava/util/List;)V", "getIssuer", "()Ljava/util/UUID;", "getJailPeriod", "()Ljava/time/Duration;", "setJailPeriod", "(Ljava/time/Duration;)V", "getJailedPlayer", "notified", "", "getRequiredItems", "setRequiredItems", "since", "", "getSince", "()J", "getCurrentFreeHours", "notifyPlayerAndTeleport", "", "cell", "Lorg/kingdoms/constants/land/structures/objects/JailStructure;", "core"})
public final class JailSession {
    @NotNull
    private final UUID jailedPlayer;
    @NotNull
    private final UUID issuer;
    @NotNull
    private Duration jailPeriod;
    private double bail;
    @NotNull
    private List<TimeRange> freeHours;
    @NotNull
    private List<ItemStack> requiredItems;
    private final long since;
    private boolean notified;

    public JailSession(@NotNull UUID jailedPlayer, @NotNull UUID issuer, @NotNull Duration jailPeriod, double bail, @NotNull List<TimeRange> freeHours, @NotNull List<ItemStack> requiredItems) {
        Intrinsics.checkNotNullParameter((Object)jailedPlayer, (String)"jailedPlayer");
        Intrinsics.checkNotNullParameter((Object)issuer, (String)"issuer");
        Intrinsics.checkNotNullParameter((Object)jailPeriod, (String)"jailPeriod");
        Intrinsics.checkNotNullParameter(freeHours, (String)"freeHours");
        Intrinsics.checkNotNullParameter(requiredItems, (String)"requiredItems");
        this.jailedPlayer = jailedPlayer;
        this.issuer = issuer;
        this.jailPeriod = jailPeriod;
        this.bail = bail;
        this.freeHours = freeHours;
        this.requiredItems = requiredItems;
        this.since = System.currentTimeMillis();
    }

    public /* synthetic */ JailSession(UUID uUID, UUID uUID2, Duration duration, double d, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            d = 0.0;
        }
        if ((n & 0x10) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            list3 = new ArrayList();
        }
        this(uUID, uUID2, duration, d, list2, list3);
    }

    @NotNull
    public final UUID getJailedPlayer() {
        return this.jailedPlayer;
    }

    @NotNull
    public final UUID getIssuer() {
        return this.issuer;
    }

    @NotNull
    public final Duration getJailPeriod() {
        return this.jailPeriod;
    }

    public final void setJailPeriod(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"<set-?>");
        this.jailPeriod = duration;
    }

    public final double getBail() {
        return this.bail;
    }

    public final void setBail(double d) {
        this.bail = d;
    }

    @NotNull
    public final List<TimeRange> getFreeHours() {
        return this.freeHours;
    }

    public final void setFreeHours(@NotNull List<TimeRange> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.freeHours = list2;
    }

    @NotNull
    public final List<ItemStack> getRequiredItems() {
        return this.requiredItems;
    }

    public final void setRequiredItems(@NotNull List<ItemStack> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.requiredItems = list2;
    }

    public final long getSince() {
        return this.since;
    }

    public final void notifyPlayerAndTeleport(@NotNull JailStructure cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Player player = KingdomsBukkitExtensions.INSTANCE.asPlayer(this.jailedPlayer);
        Intrinsics.checkNotNull((Object)player);
        Player player2 = player;
        if (!this.notified) {
            new StaticMessenger("{$e}You've been jailed by {$es}%jail_issuer% {$e}for {$es}%jail_period%").sendError((CommandSender)player2, new Object[0]);
            this.notified = true;
        }
        Location location = cell.getJailSpawn();
        Intrinsics.checkNotNull((Object)location);
        player2.teleport(location);
    }

    @Nullable
    public final TimeRange getCurrentFreeHours() {
        LocalTime now = LocalTime.now(TimeUtils.TIME_ZONE);
        for (TimeRange freeHour : this.freeHours) {
            LocalTime from = freeHour.component1();
            LocalTime to = freeHour.component2();
            if (!now.isAfter(from) || !now.isBefore(to)) continue;
            return freeHour;
        }
        return null;
    }
}

