/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.JailSession;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.KingdomsBukkitExtensions;
import org.kingdoms.utils.time.TimeRange;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0014\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006#"}, d2={"Lorg/kingdoms/constants/land/structures/objects/JailStructure;", "Lorg/kingdoms/constants/land/structures/Structure;", "style", "Lorg/kingdoms/constants/land/structures/StructureStyle;", "location", "Lorg/kingdoms/constants/land/location/SimpleLocation;", "(Lorg/kingdoms/constants/land/structures/StructureStyle;Lorg/kingdoms/constants/land/location/SimpleLocation;)V", "jailSession", "Lorg/kingdoms/constants/land/structures/JailSession;", "getJailSession", "()Lorg/kingdoms/constants/land/structures/JailSession;", "setJailSession", "(Lorg/kingdoms/constants/land/structures/JailSession;)V", "jailSpawn", "Lorg/bukkit/Location;", "getJailSpawn", "()Lorg/bukkit/Location;", "setJailSpawn", "(Lorg/bukkit/Location;)V", "getEdits", "Lorg/kingdoms/locale/provider/MessageBuilder;", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "hashCode", "", "jail", "", "release", "remove", "Lorg/kingdoms/events/items/KingdomItemBreakEvent;", "context", "Lorg/kingdoms/events/items/KingdomItemRemoveContext;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "core"})
public final class JailStructure
extends Structure {
    @Nullable
    private JailSession jailSession;
    @Nullable
    private Location jailSpawn;

    public JailStructure(@NotNull StructureStyle style, @NotNull SimpleLocation location) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        super(style, location);
    }

    @Nullable
    public final JailSession getJailSession() {
        return this.jailSession;
    }

    public final void setJailSession(@Nullable JailSession jailSession) {
        this.jailSession = jailSession;
    }

    @Nullable
    public final Location getJailSpawn() {
        return this.jailSpawn;
    }

    public final void setJailSpawn(@Nullable Location location) {
        this.jailSpawn = location;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MessageBuilder getEdits(@Nullable Kingdom kingdom) {
        MessageBuilder messageBuilder;
        MessageBuilder $this$getEdits_u24lambda_u2d1 = messageBuilder = super.getEdits(kingdom);
        boolean bl = false;
        if (this.jailSession != null) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            OfflinePlayer jailedPlayer = KingdomsBukkitExtensions.INSTANCE.asOfflinePlayer(jailSession2.getJailedPlayer());
            $this$getEdits_u24lambda_u2d1.withContext(jailedPlayer);
            $this$getEdits_u24lambda_u2d1.raw("jail_player", jailedPlayer.getName());
            $this$getEdits_u24lambda_u2d1.raw("jail_period", jailSession2.getJailPeriod().toMillis());
            $this$getEdits_u24lambda_u2d1.raw("jail_bail", jailSession2.getBail());
            $this$getEdits_u24lambda_u2d1.raw("jail_since", jailSession2.getSince());
            Iterable iterable = jailSession2.getFreeHours();
            String string = "jail_free_hours";
            MessageBuilder messageBuilder2 = $this$getEdits_u24lambda_u2d1;
            boolean $i$f$map = false;
            void var11_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                TimeRange timeRange = (TimeRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(x.getFrom().toString() + " - " + x.getTo());
            }
            collection = (List)destination$iv$iv;
            messageBuilder2.parse(string, collection);
        }
        MessageBuilder messageBuilder3 = messageBuilder;
        Intrinsics.checkNotNullExpressionValue((Object)messageBuilder3, (String)"super.getEdits(kingdom).\u2026)\n            }\n        }");
        return messageBuilder3;
    }

    public final void jail(@NotNull JailSession jailSession) {
        Intrinsics.checkNotNullParameter((Object)jailSession, (String)"jailSession");
        this.jailSession = jailSession;
        Player player = KingdomsBukkitExtensions.INSTANCE.asPlayer(jailSession.getJailedPlayer());
        if (player != null) {
            Location location = this.jailSpawn;
            Intrinsics.checkNotNull((Object)location);
            player.teleport(location);
        }
        KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer(jailSession.getJailedPlayer()).setJailCell(this.location);
    }

    @Override
    @NotNull
    public KingdomItemBreakEvent<?> remove(@NotNull KingdomItemRemoveContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.jailSession != null) {
            this.release();
        }
        KingdomItemBreakEvent<?> kingdomItemBreakEvent = super.remove(context);
        Intrinsics.checkNotNullExpressionValue(kingdomItemBreakEvent, (String)"super.remove(context)");
        return kingdomItemBreakEvent;
    }

    public final void release() {
        block0: {
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            KingdomsBukkitExtensions.INSTANCE.asKingdomPlayer(jailSession2.getJailedPlayer()).setJailCell(null);
            Player player = KingdomsBukkitExtensions.INSTANCE.asPlayer(jailSession2.getJailedPlayer());
            if (player == null) break block0;
            World world = this.location.getBukkitWorld();
            Intrinsics.checkNotNull((Object)world);
            player.teleport(world.getSpawnLocation());
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        if (this.jailSession != null) {
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            result = prime * result + jailSession2.getJailedPlayer().hashCode();
            result = prime * result + Double.hashCode(jailSession2.getBail());
            result = prime * result + jailSession2.getRequiredItems().size();
            result = prime * result + jailSession2.getFreeHours().size();
        }
        return result;
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        if (this.jailSession != null) {
            SectionableDataSetter sectionableDataSetter;
            JailSession jailSession = this.jailSession;
            Intrinsics.checkNotNull((Object)jailSession);
            JailSession jailSession2 = jailSession;
            SectionableDataSetter $this$serialize_u24lambda_u2d2 = sectionableDataSetter = json;
            boolean bl = false;
            $this$serialize_u24lambda_u2d2.setUUID("jailed", jailSession2.getJailedPlayer());
            $this$serialize_u24lambda_u2d2.setLong("jailPeriod", jailSession2.getJailPeriod().toMillis());
            $this$serialize_u24lambda_u2d2.setLong("jailedSince", jailSession2.getSince());
            $this$serialize_u24lambda_u2d2.setDouble("bail", jailSession2.getBail());
            json.get("freeHours").setCollection((Collection)jailSession2.getFreeHours(), JailStructure::serialize$lambda-4);
        }
    }

    private static final void serialize$lambda-4(SectionCreatableDataSetter eleProvider, TimeRange ele) {
        SectionableDataSetter sectionableDataSetter;
        Intrinsics.checkNotNullParameter((Object)eleProvider, (String)"eleProvider");
        Intrinsics.checkNotNullParameter((Object)ele, (String)"ele");
        LocalTime from = ele.component1();
        LocalTime to = ele.component2();
        SectionableDataSetter $this$serialize_u24lambda_u2d4_u24lambda_u2d3 = sectionableDataSetter = eleProvider.createSection();
        boolean bl = false;
        $this$serialize_u24lambda_u2d4_u24lambda_u2d3.setString("from", "" + from.getHour() + ':' + from.getMinute());
        $this$serialize_u24lambda_u2d4_u24lambda_u2d3.setString("to", "" + to.getHour() + ':' + to.getMinute());
    }
}

