/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.objects;

import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.FuelContainer;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public class WarpPad
extends Structure
implements FuelContainer {
    private double fuel;

    public WarpPad(StructureStyle type, SimpleLocation location) {
        super(type, location);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + super.hashCode();
        result = prime * result + Double.hashCode(this.fuel);
        return result;
    }

    @Override
    public double getFuel() {
        return this.fuel;
    }

    @Override
    public void setFuel(double fuel) {
        this.fuel = fuel;
    }

    @Override
    public Pair<ItemStack, NBTTagCompound> getTags() {
        Pair<ItemStack, NBTTagCompound> pair = super.getTags();
        if (pair == null) {
            return null;
        }
        NBTWrappers.NBTTagCompound tag = (NBTWrappers.NBTTagCompound)pair.getValue();
        tag = tag.getCompound("Kingdoms");
        tag.set("Fuel", NBTType.DOUBLE, this.fuel);
        return pair;
    }

    @Override
    public void setDataFromNBT(NBTTagCompound tag) {
        super.setDataFromNBT(tag);
        Double fuel = tag.get("Fuel", NBTType.DOUBLE);
        this.fuel = fuel == null ? 0.0 : fuel;
    }

    @Override
    public MessageBuilder getEdits(Kingdom kingdom) {
        return super.getEdits(kingdom).raw("fuel", this.fuel).raw("max_fuel", this.eval(((StructureStyle)this.style).getOption("fuel", "capacity"), kingdom, this.level));
    }

    @Override
    public double getMaxFuel() {
        return this.eval(((StructureStyle)this.style).getOption("fuel", "capacity"), this.getLand().getKingdom(), this.level);
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setDouble("fuel", this.fuel);
    }
}

