/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.Extractor;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.time.TimeFormatter;

public class StructureExtractor
extends StructureType {
    public StructureExtractor() {
        super("extractor");
    }

    @Override
    public InteractiveGUI open(final KingdomItemGUIContext<Structure> context) {
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        Player player = event.getPlayer().getPlayer();
        Extractor extractor = (Extractor)event.getKingdomItem();
        KingdomPlayer kp = event.getPlayer();
        MessageBuilder edits = extractor.getEdits().raw("time", TimeFormatter.of(System.currentTimeMillis() - extractor.getLastCollected())).raw("amount", extractor.getCollectedResourcePoints()).raw("extractor-last-collector", Bukkit.getOfflinePlayer((UUID)extractor.getLastCollector()).getName());
        InteractiveGUI gui = InteractiveGUIManager.getGuis().get(player.getEntityId());
        if (gui == null) {
            gui = GUIAccessor.prepare(player, "structures/extractor", edits);
            if (gui == null) {
                return null;
            }
            final InteractiveGUI finalGui = gui;
            gui.setRefreshTask(new BukkitRunnable(){

                public void run() {
                    StructureExtractor.this.open(context.refresh(finalGui));
                }
            }.runTaskTimer((Plugin)Kingdoms.get(), 20L, 20L));
        } else {
            gui.resetOptions();
            gui.setSettings(edits);
        }
        this.pushUpgrade(gui, context, extractor.getLand().getKingdom());
        InteractiveGUI finalGui1 = gui;
        gui.push("collect", () -> {
            if (extractor.getCollectedResourcePoints() <= 0L) {
                return;
            }
            extractor.collect(kp);
            this.open(context.refresh(finalGui1));
        }, new Object[0]);
        return context.finalizeGUI(gui, context.isRefreshing());
    }

    @Override
    public Extractor build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        Extractor ex = new Extractor(builder.getStyle(), builder.getLocation());
        if (builder.getPlacedBy() != null) {
            ex.setLastCollector(builder.getPlacedBy().getId());
        }
        return ex;
    }

    @Override
    public void deserialize(Structure item, DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(item, context);
        Extractor extractor = (Extractor)item;
        SectionableDataGetter provider = context.getDataProvider();
        extractor.setCollected(provider.getLong("collected"));
        extractor.setLastCollector(provider.get("lastCollector").asUUID());
        extractor.setLastCollected(provider.getLong("lastCollected"));
        extractor.setFuel(provider.getDouble("fuel"));
    }
}

