/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.structures.OutpostPurchaseItemEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.OptionHandler;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.structures.NexusManager;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.cooldown.BiCooldown;

public class StructureOutpost
extends StructureType {
    private static final BiCooldown<UUID, String> PURCHASE_COOLDOWN = new BiCooldown();
    private static final Map<SimpleItemStackHash, Integer> STOCK = new HashMap<SimpleItemStackHash, Integer>();

    public static long getPurchaseCooldown(Kingdom kingdom, StructureStyle style, String name) {
        return PURCHASE_COOLDOWN.getTimeLeft(kingdom.getId(), style.getName() + ':' + name);
    }

    public static long addPurchaseCooldown(Kingdom kingdom, StructureStyle style, String name, long millisCooldown) {
        PURCHASE_COOLDOWN.add(kingdom.getId(), style.getName() + ':' + name, millisCooldown += StructureOutpost.getPurchaseCooldown(kingdom, style, name));
        return millisCooldown;
    }

    public StructureOutpost() {
        super("outpost");
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Structure> context) {
        return StructureOutpost.open(context, 0);
    }

    public static InteractiveGUI open(KingdomItemGUIContext<Structure> context, int page) {
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        Player player = event.getPlayer().getPlayer();
        KingdomPlayer kp = event.getPlayer();
        Structure structure = (Structure)context.getEvent().getKingdomItem();
        if (kp.hasKingdom() && !kp.hasPermission(StandardKingdomPermission.OUTPOST)) {
            StandardKingdomPermission.OUTPOST.sendDeniedMessage(player);
            return null;
        }
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/outpost/" + (page + 1));
        if (gui == null) {
            return null;
        }
        Kingdom kingdom = ((Structure)event.getKingdomItem()).getLand().getKingdom();
        int maxPages = (int)kp.getLanguage().getGUIs().keySet().stream().filter(x -> x.startsWith("structures/outpost/")).filter(x -> Pattern.compile("/\\d+$").matcher((CharSequence)x).find()).count();
        gui.getSettings().inheritPlaceholders(structure.getEdits(kingdom));
        gui.getSettings().raw("pages", maxPages);
        gui.getSettings().raw("page", page + 1);
        gui.option("previous-page").onNormalClicks(ctx -> {
            if (page == 0) {
                ctx.sendError(KingdomsLang.GUIS_PAGES_PREVIOUS_PAGE_NOT_AVAILABLE, new Object[0]);
                return;
            }
            StructureOutpost.open(context, page - 1);
        }).done();
        gui.option("next-page").onNormalClicks(ctx -> {
            if (page + 1 >= maxPages) {
                ctx.sendError(KingdomsLang.GUIS_PAGES_NEXT_PAGE_NOT_AVAILABLE, new Object[0]);
                return;
            }
            StructureOutpost.open(context, page + 1);
        }).done();
        ConfigSection purchaseLimits = ((StructureStyle)structure.getStyle()).getOption("purchase-limits").getSection().getSection();
        for (String holder : gui.getRemainingOptions("sell")) {
            OptionHandler opt = gui.option(holder);
            ConfigSection config = opt.getConfig();
            if (config == null) continue;
            if (!config.isSet("perform-action")) {
                int cost = config.getInt("cost");
                ConfigSection itemSection = config.getSection("item");
                ItemStack item = XItemStack.deserialize(itemSection.toBukkitConfigurationSection(), MessageHandler::colorize);
                long perItem = 0L;
                long maxCooldown = 0L;
                long cooldown = 0L;
                AtomicReference<String> matchedName = new AtomicReference<String>();
                opt.getSettings().raw("can_purchase", true);
                for (Map.Entry<String, ConfigSection> entry : purchaseLimits.getSections().entrySet()) {
                    ConfigSection matcherSection = entry.getValue();
                    if (!new ItemMatcher(matcherSection).matches(item)) continue;
                    ConfigSection limits = Objects.requireNonNull(matcherSection.getSection("purchase-limit"), () -> "No purchase limit defined for: " + (String)entry.getKey());
                    perItem = limits.getTime("cooldown-per-item", gui.getSettings());
                    maxCooldown = limits.getTime("max-cooldown", gui.getSettings());
                    matchedName.set(entry.getKey());
                    cooldown = StructureOutpost.getPurchaseCooldown(kingdom, (StructureStyle)structure.getStyle(), entry.getKey());
                    opt.getSettings().raw("can_purchase", cooldown < maxCooldown + perItem);
                    opt.getSettings().raw("max_cooldown", maxCooldown);
                    opt.getSettings().raw("cooldown_per_item", perItem);
                }
                SimpleItemStackHash simpleItem = new SimpleItemStackHash(item);
                int stock = STOCK.getOrDefault(simpleItem, 0);
                opt.getSettings().raw("cost", cost).raw("amount", item.getAmount()).raw("stock", stock);
                long finalMaxCooldown = maxCooldown;
                long finalCooldown = cooldown;
                long finalPerItem = perItem;
                opt.onNormalClicks(ctx -> {
                    int maxItemsCanBeBought;
                    int n = maxItemsCanBeBought = finalCooldown == 0L ? 64 : (int)((finalMaxCooldown - finalCooldown) / finalPerItem);
                    if (maxItemsCanBeBought <= 0) {
                        ctx.sendError(KingdomsLang.OUTPOST_COOLDOWN, "cooldown", finalCooldown);
                        return;
                    }
                    StructureOutpost.amountPicker(player, item.clone(), 1, maxItemsCanBeBought, cost, innerGUI -> innerGUI.push("cancel", () -> StructureOutpost.open(context, page), new Object[0]), newItem -> {
                        long amountedCost = (long)cost * (long)newItem.getAmount();
                        String itemName = config.getString("item-name");
                        if (itemName == null) {
                            if (item.hasItemMeta()) {
                                ItemMeta meta = item.getItemMeta();
                                if (meta.hasLocalizedName()) {
                                    itemName = meta.getLocalizedName();
                                } else if (meta.hasDisplayName()) {
                                    itemName = meta.getDisplayName();
                                }
                            }
                            if (itemName == null) {
                                itemName = XMaterial.matchXMaterial(item).toString();
                            }
                        }
                        if (!kingdom.hasResourcePoints(amountedCost)) {
                            ctx.sendError(KingdomsLang.OUTPOST_NOT_ENOUGH_RESOURCE_POINTS, new Object[0]);
                            return;
                        }
                        OutpostPurchaseItemEvent.Purchase purchase = new OutpostPurchaseItemEvent.Purchase(holder, itemName, (ItemStack)newItem, amountedCost);
                        OutpostPurchaseItemEvent purchaseEvent = new OutpostPurchaseItemEvent((KingdomItem<?>)event.getKingdomItem(), purchase, kp);
                        Bukkit.getPluginManager().callEvent((Event)purchaseEvent);
                        if (purchaseEvent.isCancelled()) {
                            return;
                        }
                        STOCK.put(simpleItem, STOCK.getOrDefault(simpleItem, 0) + newItem.getAmount());
                        if (matchedName.get() != null) {
                            StructureOutpost.addPurchaseCooldown(kingdom, (StructureStyle)structure.getStyle(), (String)matchedName.get(), finalPerItem * (long)purchase.getItem().getAmount());
                        }
                        kingdom.addResourcePoints(-amountedCost);
                        XItemStack.giveOrDrop(player, false, purchase.getItem());
                        KingdomsLang.OUTPOST_PURCHASED.sendMessage((CommandSender)player, "amount", newItem.getAmount(), "name", itemName, "cost", amountedCost);
                        StructureOutpost.open(context, page);
                    });
                });
            }
            opt.done();
        }
        gui.push("nexus", () -> new NexusManager(kingdom, event.getPlayer().getPlayer()).openNexus(), new Object[0]);
        return context.finalizeGUI(gui);
    }

    public static InteractiveGUI amountPicker(Player player, ItemStack item, int min, int max, long costFactor, Consumer<InteractiveGUI> modifier, Consumer<ItemStack> done) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.STRUCTURES_OUTPOST_AMOUNT$PICKER);
        if (gui == null) {
            return null;
        }
        gui.getSettings().raw("cost", costFactor * (long)item.getAmount()).raw("min", min).raw("max", max).raw("cost_factor", costFactor);
        Consumer<Integer> setAmount = amt -> {
            int newAmount = item.getAmount() + amt;
            item.setAmount(Math.min(max, Math.max(min, newAmount)));
            StructureOutpost.amountPicker(player, item, min, max, costFactor, modifier, done);
        };
        gui.getSettings().raw("can_increase", item.getAmount() < max);
        gui.getSettings().raw("can_decrease", item.getAmount() > min);
        gui.option("item").editItem(x -> item).done();
        gui.option("increase").on(ClickType.LEFT, ctx -> setAmount.accept(1)).on(ClickType.SHIFT_LEFT, ctx -> setAmount.accept(10)).done();
        gui.option("decrease").on(ClickType.LEFT, ctx -> setAmount.accept(-1)).on(ClickType.SHIFT_LEFT, ctx -> setAmount.accept(-10)).done();
        gui.option("done").onNormalClicks(() -> done.accept(item)).done();
        modifier.accept(gui);
        gui.open();
        return gui;
    }

    private static final class SimpleItemStackHash {
        private final ItemStack item;

        private SimpleItemStackHash(ItemStack item) {
            this.item = item;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.item.getType().hashCode();
            hash = hash * 31 + (this.item.getDurability() & 0xFFFF);
            hash = hash * 31 + (this.item.hasItemMeta() ? this.item.getItemMeta().hashCode() : 0);
            return hash;
        }
    }
}

