/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.Regulator;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.internal.enumeration.QuickEnumSet;
import org.kingdoms.utils.string.StringUtils;

public class StructureRegulator
extends StructureType {
    public StructureRegulator() {
        super("regulator");
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Structure> context) {
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        Player player = event.getPlayer().getPlayer();
        Regulator regulator = (Regulator)event.getKingdomItem();
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/regulator");
        if (gui == null) {
            return null;
        }
        gui.push("rules", () -> this.openRules(player, regulator, context), new Object[0]).push("attributes", () -> this.openAttributes(player, regulator, context), new Object[0]).push("interactions", () -> this.openInteractions(player, regulator, context), new Object[0]);
        context.finalizeGUI(gui);
        return gui;
    }

    public void openAttribute(Player player, OfflinePlayer memberPlayer, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/attribute-editor");
        if (gui == null) {
            return;
        }
        gui.push("back", () -> this.open(context), new Object[0]);
        Set attributes = regulator.getAttributes().getOrDefault(memberPlayer.getUniqueId(), EnumSet.noneOf(Regulator.Attribute.class));
        for (Regulator.Attribute attribute : Regulator.Attribute.values()) {
            boolean enabled = attributes.contains((Object)attribute);
            gui.push(StringUtils.configOption(attribute), () -> {
                if (enabled) {
                    attributes.remove((Object)attribute);
                } else {
                    attributes.add(attribute);
                }
                regulator.getAttributes().put(memberPlayer.getUniqueId(), attributes);
                this.openAttribute(player, memberPlayer, regulator, context);
            }, "enabled", enabled);
        }
        gui.open();
    }

    public void openInteraction(Player player, KingdomPlayer kp, OfflinePlayer memberPlayer, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/interaction-editor");
        if (gui == null) {
            return;
        }
        gui.push("back", () -> this.open(context), new Object[0]);
        Set<Regulator.Interactable> interactions = regulator.getInteractions().get(memberPlayer.getUniqueId());
        for (Regulator.Interactable interaction : Regulator.Interactable.values()) {
            boolean enabled = interactions.contains((Object)interaction);
            gui.push(StringUtils.configOption(interaction), () -> {
                if (enabled) {
                    interactions.remove((Object)interaction);
                } else {
                    interactions.add(interaction);
                }
                regulator.getInteractions().put(memberPlayer.getUniqueId(), interactions);
                this.openInteraction(player, kp, memberPlayer, regulator, context);
            }, "enabled", enabled);
        }
        gui.open();
    }

    public InteractiveGUI openInteractions(Player player, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/interactions");
        if (gui == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Map<UUID, Set<Regulator.Interactable>> interactions = regulator.getInteractions();
        gui.push("back", () -> this.open(context), new Object[0]).push("add", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            KingdomsLang.REGULATOR_INTERACTIONS_ADD.sendMessage((CommandSender)player);
            gui.startConversation("add");
        }, input -> {
            OfflinePlayer add = PlayerUtils.getOfflinePlayer(input);
            if (add == null) {
                KingdomsLang.NOT_FOUND_PLAYER.sendMessage((CommandSender)player, "add", input);
                return;
            }
            if (add.getUniqueId().equals(player.getUniqueId())) {
                KingdomsLang.REGULATOR_INTERACTIONS_ADD_SELF.sendMessage((CommandSender)player);
                return;
            }
            if (interactions.containsKey(add.getUniqueId())) {
                KingdomsLang.REGULATOR_INTERACTIONS_ALREADY_ADDED.sendMessage((CommandSender)player, "add", add.getName());
                return;
            }
            interactions.put(add.getUniqueId(), EnumSet.noneOf(Regulator.Interactable.class));
            KingdomsLang.REGULATOR_INTERACTIONS_ADDED.sendMessage((CommandSender)player, "add", add.getName());
            gui.endConversation();
            this.openInteractions(player, regulator, context);
        }, new Object[0]).push("remove-all", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            interactions.clear();
            this.openInteractions(player, regulator, context);
        }, new Object[0]);
        ReusableOptionHandler holder = gui.getReusableOption("members");
        for (UUID member : interactions.keySet()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)member);
            holder.on(ClickType.LEFT, () -> this.openInteraction(player, kp, offlinePlayer, regulator, context)).on(ClickType.RIGHT, () -> {
                interactions.remove(offlinePlayer.getUniqueId());
                KingdomsLang.REGULATOR_INTERACTIONS_REMOVED.sendMessage((CommandSender)player, new MessageBuilder().withContext(offlinePlayer));
                this.openInteractions(player, regulator, context);
            }).pushHead(offlinePlayer);
        }
        gui.open();
        return gui;
    }

    public InteractiveGUI openAttributes(Player player, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/attributes");
        if (gui == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Map<UUID, Set<Regulator.Attribute>> attributes = regulator.getAttributes();
        gui.push("back", () -> this.open(context), new Object[0]).push("add", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            KingdomsLang.REGULATOR_ATTRIBUTES_ADD.sendMessage((CommandSender)player);
            gui.startConversation("add");
        }, input -> {
            OfflinePlayer add = PlayerUtils.getOfflinePlayer(input);
            if (add == null) {
                KingdomsLang.NOT_FOUND_PLAYER.sendMessage((CommandSender)player, "add", input);
                return;
            }
            if (add.getUniqueId().equals(player.getUniqueId())) {
                KingdomsLang.REGULATOR_ATTRIBUTES_ADD_SELF.sendMessage((CommandSender)player);
                return;
            }
            if (attributes.containsKey(add.getUniqueId())) {
                KingdomsLang.REGULATOR_ATTRIBUTES_ALREADY_ADDED.sendMessage((CommandSender)player, "add", add.getName());
                return;
            }
            attributes.put(add.getUniqueId(), EnumSet.noneOf(Regulator.Attribute.class));
            KingdomsLang.REGULATOR_ATTRIBUTES_ADDED.sendMessage((CommandSender)player, "add", add.getName());
            gui.endConversation();
            this.openAttributes(player, regulator, context);
        }, new Object[0]).push("remove-all", () -> {
            if (!kp.hasPermission(StandardKingdomPermission.STRUCTURES)) {
                StandardKingdomPermission.STRUCTURES.sendDeniedMessage(player);
                return;
            }
            attributes.clear();
            this.openAttributes(player, regulator, context);
        }, new Object[0]);
        ReusableOptionHandler holder = gui.getReusableOption("members");
        for (UUID member : attributes.keySet()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)member);
            holder.on(ClickType.LEFT, () -> this.openAttribute(player, offlinePlayer, regulator, context)).on(ClickType.RIGHT, () -> {
                attributes.remove(offlinePlayer.getUniqueId());
                KingdomsLang.REGULATOR_ATTRIBUTES_REMOVED.sendMessage((CommandSender)player, new MessageBuilder().withContext(offlinePlayer));
                this.openAttributes(player, regulator, context);
            }).pushHead(offlinePlayer);
        }
        gui.open();
        return gui;
    }

    public InteractiveGUI openRules(Player player, Regulator regulator, KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui = GUIAccessor.prepare(player, "structures/regulator/rules");
        if (gui == null) {
            return null;
        }
        gui.push("back", () -> this.open(context), new Object[0]);
        for (Regulator.Rule rule : Regulator.Rule.values()) {
            String name = StringUtils.configOption(rule);
            boolean enabled = regulator.hasRule(rule);
            gui.push(name, () -> {
                if (enabled) {
                    regulator.getRules().remove((Object)rule);
                } else {
                    regulator.getRules().add(rule);
                }
                this.openRules(player, regulator, context);
            }, "enabled", enabled);
        }
        gui.open();
        return gui;
    }

    @Override
    public Regulator build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        return new Regulator(builder.getStyle(), builder.getLocation());
    }

    @Override
    public void deserialize(Structure item, DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(item, context);
        Regulator regulator = (Regulator)item;
        SectionableDataGetter provider = context.getDataProvider();
        regulator.setRules(provider.get("rules").asCollection(new QuickEnumSet((Enum[])Regulator.Rule.values()), (c, elementProvider) -> {
            String str = elementProvider.asString();
            if (str != null) {
                c.add(Regulator.Rule.valueOf(str));
            }
        }));
        regulator.setAttributes(provider.get("attributes").asMap(new HashMap(), (map, key, value) -> {
            QuickEnumSet attrs = value.asCollection(new QuickEnumSet((Enum[])Regulator.Attribute.values()), (c, elementProvider) -> {
                String str = elementProvider.asString();
                if (str != null) {
                    c.add(Regulator.Attribute.valueOf(str));
                }
            });
            map.put(key.asUUID(), attrs);
        }));
        regulator.setInteractions(provider.get("interactions").asMap(new HashMap(), (map, key, value) -> {
            QuickEnumSet interactables = value.asCollection(new QuickEnumSet((Enum[])Regulator.Interactable.values()), (c, elementProvider) -> c.add(Regulator.Interactable.valueOf(elementProvider.asString())));
            map.put(key.asUUID(), interactables);
        }));
    }
}

