/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.Map;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.SiegeCannon;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.gui.GUIBuilder;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InventoryInteractiveGUI;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.ItemMatcher;
import org.kingdoms.managers.structures.SiegeCannonAmmo;
import org.kingdoms.utils.config.ConfigSection;

public class StructureSiegeCannon
extends StructureType {
    public StructureSiegeCannon() {
        super("siege-cannon");
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Structure> context) {
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        Player player = event.getPlayer().getPlayer();
        Structure structure = (Structure)event.getKingdomItem();
        Kingdom kingdom = structure.getLand().getKingdom();
        SiegeCannon cannon = (SiegeCannon)structure;
        InventoryInteractiveGUI gui = (InventoryInteractiveGUI)new GUIBuilder("structures/siege-cannon").forPlayer(player).withSettings(cannon.getEdits(kingdom)).inventoryGUIOnly().build();
        if (gui == null) {
            return null;
        }
        this.pushUpgrade(gui, context, kingdom);
        gui.push("sit", () -> {
            if (cannon.getHandler() != null) {
                KingdomsLang.SIEGE_CANNON_OCCUPIED.sendError((CommandSender)player, new Object[0]);
                return;
            }
            if (KingdomsConfig.Invasions.MASSWAR_ALLOW_SIEGE_CANNONS.getManager().getBoolean()) {
                KingdomsLang.SIEGE_CANNON_MASSWAR_ONLY.sendError((CommandSender)player, new Object[0]);
                return;
            }
            cannon.sit(player);
            KingdomsLang.SIEGE_CANNON_SIT.sendMessage((CommandSender)player);
        }, new Object[0]);
        gui.onDelayedInteractableSlot(interactEvent -> {
            Map<Integer, ItemStack> items = gui.getInteractableMap(true);
            if (items.isEmpty()) {
                return;
            }
            player.getOpenInventory().getTopInventory().setItem(items.keySet().iterator().next().intValue(), null);
            player.updateInventory();
            if (cannon.isLoaded()) {
                KingdomsLang.SIEGE_CANNON_ALREADY_LOADED.sendError((CommandSender)player, new Object[0]);
                XItemStack.giveOrDrop(player, items.values().toArray(new ItemStack[0]));
                return;
            }
            ItemStack item = items.values().iterator().next();
            ConfigSection ammos = Objects.requireNonNull(((StructureStyle)structure.getStyle()).getOption("projectiles").getSection(), () -> "Projectiles option not present for " + ((StructureStyle)structure.getStyle()).getName()).getSection();
            ConfigSection matched = null;
            for (Map.Entry<String, ConfigSection> section : ammos.getSections().entrySet()) {
                ConfigSection itemSection = section.getValue().getSection("item");
                ItemMatcher matcher = new ItemMatcher(itemSection);
                if (!matcher.matches(item)) continue;
                matched = section.getValue();
            }
            if (matched == null) {
                KingdomsLang.SIEGE_CANNON_NOT_AMMO.sendError((CommandSender)player, new Object[0]);
                XItemStack.giveOrDrop(player, items.values().toArray(new ItemStack[0]));
                return;
            }
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                XItemStack.giveOrDrop(player, item);
            }
            cannon.load(new SiegeCannonAmmo(matched));
            cannon.playSound("load");
            KingdomsLang.SIEGE_CANNON_READY_FIRE.sendMessage((CommandSender)player);
            if (player != cannon.getHandler() && cannon.getHandler() != null) {
                KingdomsLang.SIEGE_CANNON_READY_FIRE.sendMessage((CommandSender)cannon.getHandler());
            }
            this.open(context);
        });
        return context.finalizeGUI(gui);
    }

    @Override
    public SiegeCannon build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        return new SiegeCannon(builder.getStyle(), builder.getLocation());
    }
}

