/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.WarpPad;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.events.items.structures.WarpPadTeleportEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.GUIMultiPagination;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.main.KingdomsPluginPermission;
import org.kingdoms.managers.teleportation.TeleportTask;
import org.kingdoms.managers.teleportation.TpManager;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.PaperUtils;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.string.StringUtils;

public class StructureWarpPad
extends StructureType {
    public StructureWarpPad() {
        super("warppad");
    }

    private static void animateTeleportation(final Location location) {
        new BukkitRunnable(){
            static final int count = 6;
            static final double radius = 1.0;
            static final double rotate = 1.0471975511965976;
            final ParticleDisplay display;
            double y;
            double rate;
            {
                this.display = ParticleDisplay.simple(location, Particle.PORTAL).withCount(5).offset(0.05, 0.05, 0.05);
                this.y = 0.0;
                this.rate = 0.2;
            }

            public void run() {
                double rotation = 0.0;
                for (int c = 0; c < 6; ++c) {
                    double x = 1.0 * Math.sin(rotation);
                    double z = 1.0 * Math.cos(rotation);
                    this.display.spawn(x, this.y, z);
                    rotation += 1.0471975511965976;
                }
                this.y += this.rate;
                if (this.y >= 3.0) {
                    this.rate = -this.rate;
                } else if (this.y <= 0.0) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 1L, 1L);
    }

    private static void handleTeleportation(final Player player, WarpPad warpPad, final Location location) {
        if (TpManager.alreadyTping(player)) {
            return;
        }
        final int timer = ((StructureStyle)warpPad.getStyle()).getOption("teleport-delay").getInt();
        if (timer <= 0 || PlayerUtils.invulnerableGameMode(player) || KingdomsPluginPermission.STRUCTURES_WARPPAD_BYPASS_COUNTDOWN.hasPermission((CommandSender)player, true)) {
            StructureWarpPad.animateTeleportation(player.getLocation());
            Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
                player.teleport(location);
                StructureWarpPad.animateTeleportation(player.getLocation());
            }, 10L);
            KingdomsLang.WARPPAD_SUCCESS.sendMessage((CommandSender)player);
            return;
        }
        PaperUtils.prepareChunksIgnored(timer, location);
        TeleportTask task = new TeleportTask(player, new BukkitRunnable(){
            int timed;
            {
                this.timed = timer;
            }

            public void run() {
                if (this.timed <= 0) {
                    Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> player.teleport(location));
                    KingdomsLang.WARPPAD_SUCCESS.sendMessage((CommandSender)player);
                    StructureWarpPad.animateTeleportation(location);
                    TpManager.end((Entity)player);
                } else {
                    KingdomsLang.WARPPAD_TELEPORTING.sendMessage((CommandSender)player, "countdown", this.timed);
                    if (--this.timed == 1) {
                        StructureWarpPad.animateTeleportation(player.getLocation());
                    }
                }
            }
        }.runTaskTimerAsynchronously((Plugin)Kingdoms.get(), 0L, 20L));
        task.assignBasicMoveChecks();
        TpManager.put(task);
    }

    @Override
    public InteractiveGUI open(KingdomItemGUIContext<Structure> context) {
        return StructureWarpPad.openPagedAsync(context, 0);
    }

    private static InteractiveGUI openPagedAsync(KingdomItemGUIContext<Structure> context, int page) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Kingdoms.get(), () -> StructureWarpPad.openPaged(context, page));
        return null;
    }

    private static InteractiveGUI openPaged(KingdomItemGUIContext<Structure> context, int page) {
        Kingdom kingdom;
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        Player player = event.getPlayer().getPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        WarpPad warppad = (WarpPad)event.getKingdomItem();
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.STRUCTURES_WARPPAD, warppad.getEdits(kingdom = warppad.getLand().getKingdom()));
        if (gui == null) {
            return null;
        }
        GUIMultiPagination pagination = new GUIMultiPagination(gui, page, openPage -> StructureWarpPad.openPaged(context, openPage));
        HashMap<String, List> mapped = new HashMap<String, List>(StructureRegistry.getTypes().size());
        List<Structure> structures = kingdom.getAllStructures();
        for (Structure structure : structures) {
            List ofType = mapped.computeIfAbsent(((StructureType)((StructureStyle)structure.getStyle()).getType()).getName(), e -> new ArrayList());
            ofType.add(structure);
        }
        for (String type : StructureRegistry.getTypes().keySet()) {
            List mappedType = (List)mapped.get(type);
            pagination.paginate(type, mappedType);
        }
        for (GUIMultiPagination.MappedOption mappedOption : pagination.paginate()) {
            ReusableOptionHandler option = mappedOption.getOption();
            for (Structure structure : mappedOption.getCollection()) {
                if (!option.hasNext()) continue;
                SimpleLocation location = structure.getLocation();
                double distance = warppad.getLocation().getWorld().equals(structure.getLocation().getWorld()) ? warppad.getLocation().distanceSquared(structure.getLocation()) : ((StructureStyle)warppad.getStyle()).getOption("other-world-distance-factor").getDouble();
                double cost = ((StructureStyle)warppad.getStyle()).getOption("fuel", "enabled").getBoolean() ? MathUtils.eval(((StructureStyle)warppad.getStyle()).getOption("teleport-fuel-cost").getString(), kingdom, "lvl", warppad.getLevel(), "distance", distance) : 0.0;
                option.setEdits("fuel-cost", StringUtils.toFancyNumber(cost), "world", location.getWorld(), "x", location.getX(), "y", location.getY(), "z", location.getZ(), "structure-name", structure.getNameOrDefault()).onNormalClicks(() -> {
                    player.closeInventory();
                    if (!kp.isAdmin() && !warppad.hasFuel(cost)) {
                        KingdomsLang.WARPPAD_LOW_FUEL.sendError((CommandSender)player, "fuel-cost", StringUtils.toFancyNumber(cost), "fuel", StringUtils.toFancyNumber(warppad.getFuel()));
                        return;
                    }
                    Location loc = LocationUtils.getSafeLocation(structure.getLocation().toBukkitLocation().add(0.5, 0.0, 0.5));
                    if (loc == null) {
                        KingdomsLang.WARPPAD_NO_SAFE_LOCATION.sendError((CommandSender)player, new Object[0]);
                        return;
                    }
                    WarpPadTeleportEvent teleportEvent = new WarpPadTeleportEvent(warppad, kp, structure, loc, cost);
                    Bukkit.getPluginManager().callEvent((Event)teleportEvent);
                    if (teleportEvent.isCancelled()) {
                        return;
                    }
                    if (!kp.isAdmin()) {
                        warppad.addFuel(-teleportEvent.getFuelCost());
                    }
                    warppad.playSound("teleport-sound");
                    StructureWarpPad.handleTeleportation(player, warppad, teleportEvent.getLocation());
                }).done();
            }
        }
        return context.finalizeGUI(gui);
    }

    @Override
    public WarpPad build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        return new WarpPad(builder.getStyle(), builder.getLocation());
    }

    @Override
    public void deserialize(Structure item, DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(item, context);
        WarpPad warpPad = (WarpPad)item;
        warpPad.setFuel(context.getDataProvider().getDouble("fuel"));
    }
}

