/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomItem;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.events.items.turrets.TurretActivateEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.turrets.TurretFactory;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.PlayerUtils;

public class Turret
extends KingdomItem<TurretStyle> {
    private TurretActivateEvent lastActivation;

    public Turret(@NonNull TurretStyle style, @NonNull SimpleLocation location) {
        super("Turret", style, location);
    }

    public boolean checkup() {
        return false;
    }

    public boolean targetCheckup(LivingEntity target) {
        return !this.canTargetEntityType(target.getType());
    }

    public boolean canSetOnFire(Kingdom kingdom) {
        return this.setOnFireLevel(kingdom) <= this.level;
    }

    public boolean canDetectInvisible(Kingdom kingdom) {
        return this.level >= this.invisibilityDetectionLevel(kingdom);
    }

    public void remove(Land land) {
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> this.location.getBlock().setType(Material.AIR), 1L);
        land.getTurrets().remove(this.location);
    }

    public boolean canTargetEntityType(EntityType entityType) {
        return ((TurretStyle)this.style).getAllowedEntityTypes().contains(entityType);
    }

    public @NonNull List<PotionEffect> getEffects() {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("effects").getSection();
        if (section == null) {
            return new ArrayList<PotionEffect>();
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        List<String> effects = section.getStringList(String.valueOf(entry));
        return XPotion.parseEffects(effects).stream().filter(XPotion.Effect::hasChance).map(XPotion.Effect::getEffect).collect(Collectors.toList());
    }

    public @Nullable ParticleDisplay getParticle() {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("particle").getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        ConfigAccessor display = section.gotoSection(String.valueOf(entry));
        if (display == null) {
            return null;
        }
        return ParticleDisplay.fromConfig(display.toBukkitConfigurationSection());
    }

    public void applyKnockback(LivingEntity target, Kingdom kingdom) {
        LocationUtils.knockback(this.location.toVector(), (Entity)target, this.getKnockback(kingdom), this.getVerticalKnockback(kingdom, this.level));
    }

    public double getKnockback(Kingdom kingdom) {
        return this.getKnockback(kingdom, this.level);
    }

    public double getKnockback(Kingdom kingdom, int lvl) {
        return this.eval("knockback", kingdom, lvl);
    }

    public double getVerticalKnockback(Kingdom kingdom, int lvl) {
        return this.eval("vertical-knockback", kingdom, lvl);
    }

    @Override
    protected void removeData() {
        this.getLand().getTurrets().remove(this.location);
    }

    @Override
    public MessageBuilder getEdits(Kingdom kingdom) {
        return super.getEdits(kingdom).raw("damage", this.round(this.getDamage(kingdom))).raw("next_damage", this.round(this.getDamage(kingdom, this.level + 1)));
    }

    public double getDamage(@NonNull Kingdom kingdom) {
        return this.getDamage(kingdom, this.level);
    }

    public double getDamage(@NonNull Kingdom kingdom, int lvl) {
        return this.eval("damage", kingdom, lvl);
    }

    public int setOnFireLevel(@NonNull Kingdom kingdom) {
        return (int)this.eval("fire", kingdom, this.level);
    }

    public int invisibilityDetectionLevel(@NonNull Kingdom kingdom) {
        return (int)this.eval("invisibility-detection", kingdom, this.level);
    }

    public int getArmorDamage(@NonNull Kingdom kingdom, int lvl) {
        return (int)this.eval("armor-damage", kingdom, lvl);
    }

    public int getArmorDamage(@NonNull Kingdom kingdom) {
        return this.getArmorDamage(kingdom, this.level);
    }

    public void damage(@NonNull TurretActivateEvent event) {
        event.getTarget().damage(this.getDamage(event.getKingdom()));
    }

    public List<String> getDeathMessages() {
        return ((TurretStyle)this.style).getOption("death-messages").getStringList();
    }

    public @Nullable String chooseDeathMessage() {
        List<String> messages = this.getDeathMessages();
        if (messages == null || messages.isEmpty()) {
            return null;
        }
        int rand = ThreadLocalRandom.current().nextInt(0, messages.size());
        return messages.get(rand);
    }

    public void activate(LivingEntity target, Kingdom kingdom) {
        target.addPotionEffects(this.getEffects());
        this.applyKnockback(target, kingdom);
        if (this.canSetOnFire(kingdom)) {
            target.setFireTicks(200);
        }
        PlayerUtils.damageArmor(target, this.getArmorDamage(kingdom));
        if (this.lastActivation != null) {
            TurretFactory.DAMAGED.put((Object)target.getEntityId(), (Object)this.lastActivation);
        }
    }

    public TurretActivateEvent getLastActivation() {
        return this.lastActivation;
    }

    public void setLastActivation(TurretActivateEvent lastActivation) {
        this.lastActivation = lastActivation;
    }
}

