/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets.objects;

import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.kingdoms.config.ConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.data.Pair;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.nbt.NBTTagCompound;
import org.kingdoms.utils.nbt.NBTType;
import org.kingdoms.utils.nbt.NBTWrappers;

public class MineTurret
extends Turret {
    private int durability;
    private transient boolean isActivating;

    public MineTurret(@NonNull TurretStyle type, @NonNull SimpleLocation location) {
        super(type, location);
    }

    public boolean createExplosion(Location location, Kingdom kingdom) {
        return this.createExplosion(location, kingdom, this.level);
    }

    public boolean createExplosion(Location location, Kingdom kingdom, int lvl) {
        ConfigAccessor section = ((TurretStyle)this.style).getOption("explosion").getSection();
        if (section == null) {
            return false;
        }
        int fromLevel = section.getInt("level");
        if (lvl < fromLevel) {
            return false;
        }
        int fire = section.getInt("fire");
        return location.getWorld().createExplosion(location, (float)MathUtils.eval(section.getString("power"), kingdom, "lvl", lvl), lvl >= fire);
    }

    public static void spawnLingeringPotion(Location location, Collection<PotionEffect> effects) {
        World world = location.getWorld();
        ItemStack lingeringPotion = XMaterial.LINGERING_POTION.parseItem();
        PotionMeta meta = (PotionMeta)lingeringPotion.getItemMeta();
        effects.forEach(effect -> meta.addCustomEffect(effect, true));
        lingeringPotion.setItemMeta((ItemMeta)meta);
        ThrownPotion pot = (ThrownPotion)world.spawnEntity(location, EntityType.SPLASH_POTION);
        pot.setItem(lingeringPotion);
        AreaEffectCloud areaCloud = (AreaEffectCloud)world.spawnEntity(location, EntityType.AREA_EFFECT_CLOUD);
        effects.forEach(effect -> areaCloud.addCustomEffect(effect, true));
    }

    public void beepBeep(XSound.Record sound, Runnable runnable) {
        Location loc = this.getLocation().toBukkitLocation();
        BiSupplier<Long, Runnable> delay = (ticks, next) -> Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            next.run();
            sound.play(loc);
        }, ticks.longValue());
        delay.apply(0L, () -> delay.apply(10L, () -> delay.apply(7L, () -> delay.apply(5L, () -> delay.apply(3L, () -> delay.apply(3L, () -> delay.apply(2L, () -> delay.apply(2L, runnable))))))));
    }

    public int getDurability() {
        return this.durability;
    }

    public void setDurability(int durability) {
        this.durability = durability;
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        if (this.durability > 1) {
            context.getDataProvider().setInt("durability", this.durability);
        }
    }

    @Override
    public Pair<ItemStack, NBTTagCompound> getTags() {
        Pair<ItemStack, NBTTagCompound> pair = super.getTags();
        if (pair == null) {
            return null;
        }
        NBTWrappers.NBTTagCompound tag = (NBTWrappers.NBTTagCompound)pair.getValue();
        tag = tag.getCompound("Kingdoms");
        if (this.durability > 1) {
            tag.set("Durability", NBTType.INTEGER, this.durability);
        }
        return pair;
    }

    @Override
    public void setDataFromNBT(NBTTagCompound tag) {
        super.setDataFromNBT(tag);
        Integer dur = tag.get("Durability", NBTType.INTEGER);
        this.durability = dur == null ? 0 : dur;
    }

    @Override
    public MessageBuilder getEdits(Kingdom kingdom) {
        return super.getEdits(kingdom).raw("durability", this.durability);
    }

    @FunctionalInterface
    public static interface BiSupplier<F, S> {
        public void apply(F var1, S var2);
    }
}

