/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.metadata;

import java.util.Collection;
import org.kingdoms.constants.metadata.KingdomMetadataHandler;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.namespace.Lockable;
import org.kingdoms.constants.namespace.NamespaceRegistry;
import org.kingdoms.data.DataManager;

public final class KingdomMetadataRegistry
extends NamespaceRegistry<KingdomMetadataHandler>
implements Lockable {
    private static boolean ACCEPT_REGISTERS = true;

    @Override
    public void register(KingdomMetadataHandler value) {
        if (value.getNamespace().getNamespace().equals("kingdoms")) {
            throw new IllegalArgumentException("Cannot register metadata handlers as kingdoms namespace: " + value);
        }
        super.register(value);
    }

    @Override
    public void lock() {
        if (!ACCEPT_REGISTERS) {
            throw new IllegalAccessError("Registers are already closed");
        }
        ACCEPT_REGISTERS = false;
    }

    public static void removeMetadata(DataManager<?, ?> dataManager, Collection<KingdomMetadataHandler> metadataHandlers) {
        for (KingdomsObject data : dataManager.getLoadedData()) {
            metadataHandlers.forEach(x -> data.getMetadata().remove(x));
        }
    }
}

