/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.metadata;

import java.util.List;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.metadata.KingdomMetadata;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.flatfile.json.KingdomsGson;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 42\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010&\u001a\u0004\u0018\u00010'H\u0002J\u0013\u0010(\u001a\u00020\u00062\b\u0010)\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010*\u001a\u00020\u0012H\u0016J\"\u0010+\u001a\u00020,2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u0014\u00102\u001a\u00020\u00062\n\u0010-\u001a\u0006\u0012\u0002\b\u00030.H\u0016J\b\u00103\u001a\u00020\u001aH\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001f\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u001e8F\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\u0004\u00a8\u00065"}, d2={"Lorg/kingdoms/constants/metadata/StandardKingdomMetadata;", "Lorg/kingdoms/constants/metadata/KingdomMetadata;", "value", "", "(Ljava/lang/Object;)V", "boolean", "", "getBoolean", "()Z", "double", "", "getDouble", "()D", "float", "", "getFloat", "()F", "int", "", "getInt", "()I", "long", "", "getLong", "()J", "string", "", "getString", "()Ljava/lang/String;", "stringList", "", "getStringList$annotations", "()V", "getStringList", "()Ljava/util/List;", "getValue", "()Ljava/lang/Object;", "setValue", "asNumber", "", "equals", "other", "hashCode", "serialize", "", "container", "Lorg/kingdoms/constants/metadata/KingdomsObject;", "context", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionCreatableDataSetter;", "shouldSave", "toString", "Companion", "core"})
public final class StandardKingdomMetadata
implements KingdomMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Object value;

    public StandardKingdomMetadata(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(@NotNull Object object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<set-?>");
        this.value = object;
    }

    @NotNull
    public final String getString() {
        return this.getValue().toString();
    }

    public final int getInt() {
        Number number = this.asNumber();
        Intrinsics.checkNotNull((Object)number);
        return number.intValue();
    }

    public final float getFloat() {
        Number number = this.asNumber();
        Intrinsics.checkNotNull((Object)number);
        return number.floatValue();
    }

    public final double getDouble() {
        Number number = this.asNumber();
        Intrinsics.checkNotNull((Object)number);
        return number.doubleValue();
    }

    public final long getLong() {
        Number number = this.asNumber();
        Intrinsics.checkNotNull((Object)number);
        return number.longValue();
    }

    public final boolean getBoolean() {
        Object object = this.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
        return (Boolean)object;
    }

    private final Number asNumber() {
        return (Number)this.getValue();
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    @NotNull
    public String toString() {
        return "KingdomMetadata { " + this.getValue() + " }";
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof StandardKingdomMetadata && Intrinsics.areEqual((Object)this.getValue(), (Object)((StandardKingdomMetadata)other).getValue());
    }

    @Nullable
    public final List<String> getStringList() {
        return (List)this.getValue();
    }

    public static /* synthetic */ void getStringList$annotations() {
    }

    @Override
    public void serialize(@NotNull KingdomsObject<?> container, @NotNull SerializationContext<SectionCreatableDataSetter> context) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        context.getDataProvider().setString(KingdomsGson.toJson(this.getValue()));
    }

    @Override
    public boolean shouldSave(@NotNull KingdomsObject<?> container) {
        Intrinsics.checkNotNullParameter(container, (String)"container");
        return true;
    }

    @JvmStatic
    @NotNull
    public static final StandardKingdomMetadata of(@NotNull Object value) {
        return Companion.of(value);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/kingdoms/constants/metadata/StandardKingdomMetadata$Companion;", "", "()V", "of", "Lorg/kingdoms/constants/metadata/StandardKingdomMetadata;", "value", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final StandardKingdomMetadata of(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new StandardKingdomMetadata(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

