/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.InvasionOperator;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.objects.JailStructure;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.KingdomsChatChannel;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.KingdomsDataCenter;
import org.kingdoms.data.Pair;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.members.KingdomJoinEvent;
import org.kingdoms.events.members.KingdomLeaveEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.events.members.PlayerChangeChatChannelEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.LanguageManager;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.land.KingdomsMap;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.FastUUID;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public class KingdomPlayer
extends KingdomsObject<UUID>
implements Comparable<KingdomPlayer>,
InvasionOperator,
KingdomOperator {
    private final transient @NonNull LinkedList<Pair<Set<SimpleChunkLocation>, Boolean>> landHistory = new LinkedList();
    private long joinedAt;
    private long lastPowerCheckup;
    private long lastDonationTime;
    private long lastDonationAmount;
    private long totalDonations;
    private @Nullable UUID kingdom;
    private final transient UUID id;
    private transient boolean autoMap;
    private transient boolean flying;
    private transient Boolean autoClaim;
    private boolean admin;
    private boolean pvp;
    private boolean spy;
    private boolean markers;
    private boolean sneakMode;
    private transient @Nullable Invasion invasion;
    private @NonNull Set<UUID> readMails;
    private @Nullable String rank;
    private @Nullable String nationalRank;
    private @Nullable String markersType;
    private @NonNull String chatChannel;
    private @NonNull Set<String> mutedChannels;
    private @NonNull Map<UUID, KingdomInvite> invites;
    private @NonNull Set<SimpleChunkLocation> claims;
    private Set<SimpleLocation> protectedBlocks;
    private transient int landHistoryPosition = -1;
    private double power;
    private @NonNull SupportedLanguage language = LanguageManager.getDefaultLanguage();
    private @Nullable Pair<Integer, Integer> mapSize;
    private @Nullable SimpleLocation jailCell;

    public KingdomPlayer(@Nullable UUID id, @Nullable UUID kingdom, long joinedAt) {
        this.id = id;
        this.kingdom = kingdom;
        this.joinedAt = joinedAt;
        this.lastPowerCheckup = System.currentTimeMillis();
        this.claims = new HashSet<SimpleChunkLocation>();
        this.invites = new NonNullMap<UUID, KingdomInvite>();
        this.readMails = new HashSet<UUID>();
        this.markers = KingdomsConfig.Claims.INDICATOR_VISUALIZER_ENABLED.getManager().getBoolean();
        this.chatChannel = KingdomsChatChannel.getGlobalChannel().getDataId();
        this.mutedChannels = new HashSet<String>();
        if (id != null) {
            KingdomsDataCenter.get().getKingdomPlayerManager().load(this);
        }
    }

    public KingdomPlayer(@NonNull UUID id, @Nullable UUID kingdom, @NonNull SupportedLanguage language, @Nullable String rank, @Nullable String nationalRank, @NonNull String chatChannel, @Nullable String markersType, long joinedAt, double power, long lastDonationTime, long lastDonationAmount, long totalDonations, long lastPowerCheckup, @NonNull Set<UUID> readMails, @NonNull Map<UUID, KingdomInvite> invites, @Nullable Set<SimpleChunkLocation> claims, @Nullable Pair<Integer, Integer> mapSize, boolean markers, boolean pvp, boolean admin, boolean spy, boolean sneakMode, @NonNull Set<String> mutedChannels) {
        this.id = id;
        this.kingdom = kingdom;
        this.rank = rank;
        this.nationalRank = nationalRank;
        this.markersType = markersType;
        this.chatChannel = Objects.requireNonNull(chatChannel, "Player chat channel cannot be null");
        this.joinedAt = joinedAt;
        this.power = power;
        this.mutedChannels = Objects.requireNonNull(mutedChannels);
        this.lastPowerCheckup = lastPowerCheckup;
        this.language = language;
        this.lastDonationTime = lastDonationTime;
        this.lastDonationAmount = lastDonationAmount;
        this.totalDonations = totalDonations;
        this.readMails = readMails;
        this.invites = invites;
        this.claims = Objects.requireNonNull(claims, "Player claims cannot be null");
        this.pvp = pvp;
        this.spy = spy;
        this.admin = admin;
        this.markers = markers;
        this.sneakMode = sneakMode;
        this.mapSize = mapSize;
    }

    public static @NonNull KingdomPlayer getKingdomPlayer(@NonNull OfflinePlayer player) {
        return KingdomPlayer.getKingdomPlayer(player.getUniqueId());
    }

    public static @NonNull KingdomPlayer getKingdomPlayer(@NonNull UUID id) {
        KingdomPlayer kp = (KingdomPlayer)KingdomsDataCenter.get().getKingdomPlayerManager().getData(id);
        return kp == null ? new KingdomPlayer(id, null, System.currentTimeMillis()) : kp;
    }

    public boolean hasKingdom() {
        return this.kingdom != null;
    }

    public int countUnreadMails(Map<UUID, Mail> mails) {
        return (int)mails.keySet().stream().filter(m -> !this.readMails.contains(m)).count();
    }

    public @Nullable Player getPlayer() {
        return Bukkit.getPlayer((UUID)this.id);
    }

    public boolean isInSameKingdomAs(KingdomPlayer kp) {
        return this.kingdom != null && kp.kingdom != null && FastUUID.equals(this.kingdom, kp.kingdom);
    }

    public @NonNull OfflinePlayer getOfflinePlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.id);
    }

    @Override
    public @Nullable Kingdom getKingdom() {
        if (this.kingdom == null) {
            return null;
        }
        Kingdom kingdomInstance = Kingdom.getKingdom(this.kingdom);
        if (kingdomInstance == null) {
            MessageHandler.sendConsolePluginMessage("&4Invalid kingdom data for &e" + this.getOfflinePlayer().getName() + " (" + this.id + ") &4removing player data...");
            this.silentlyLeaveKingdom();
            return null;
        }
        return kingdomInstance;
    }

    public SimpleLocation getJailCell() {
        return this.jailCell;
    }

    public void setJailCell(SimpleLocation jailCell) {
        this.jailCell = jailCell;
    }

    public @Nullable Rank getRank() {
        Kingdom kingdom = this.getKingdom();
        if (kingdom == null) {
            return null;
        }
        if (this.rank == null) {
            return kingdom.getRanks().getLowestRank();
        }
        Rank rank = kingdom.getRanks().get(this.rank);
        if (rank != null) {
            return rank;
        }
        rank = kingdom.getKingId().equals(this.id) ? kingdom.getRanks().getHighestRank() : kingdom.getRanks().getLowestRank();
        this.rank = rank.getNode();
        return rank;
    }

    public void setRankInternal(@Nullable String rank) {
        this.rank = rank;
    }

    public void setNationalRankInternal(@Nullable String nationalRank) {
        this.nationalRank = nationalRank;
    }

    public PlayerRankChangeEvent setRank(KingdomPlayer byPlayer, @NonNull Rank rank) {
        Objects.requireNonNull(rank, "Kingdom member rank cannot be null");
        Kingdom kingdom = this.getKingdom();
        if (!kingdom.getRanks().has(rank.getNode())) {
            throw new IllegalArgumentException("The specified rank '" + rank.getNode() + "' is not in kingdom: " + kingdom.getName());
        }
        Rank oldRank = this.rank == null ? kingdom.getRanks().getLowestRank() : kingdom.getRanks().get(this.rank);
        PlayerRankChangeEvent event = new PlayerRankChangeEvent(oldRank, rank, kingdom, this, byPlayer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.rank = rank.getNode();
        return event;
    }

    public @Nullable String getRankNode() {
        return this.rank;
    }

    public KingdomLeaveEvent leaveKingdom(LeaveReason reason) {
        Objects.requireNonNull(reason, "Kingdom leave reason cannot be null");
        Objects.requireNonNull(this.kingdom, "Player is not a member of a kingdom to leave");
        KingdomLeaveEvent event = new KingdomLeaveEvent(this, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.getKingdom().getMembers().remove(this.id);
        this.silentlyLeaveKingdom();
        return event;
    }

    public void silentlyLeaveKingdom() {
        Nation nation;
        Kingdom kingdom;
        if (this.jailCell != null) {
            Land land = this.jailCell.toSimpleChunkLocation().getLand();
            JailStructure jailCellStructure = (JailStructure)land.getStructures().get(this.jailCell);
            jailCellStructure.release();
        }
        if (this.nationalRank != null && (kingdom = this.getKingdom()) != null && (nation = kingdom.getNation()) != null && nation.getRanks().get(this.nationalRank).isKing()) {
            KingdomPlayer nextKing = Rank.determineNextKing((ArrayList)kingdom.getKingdomPlayers(), null);
            nextKing.nationalRank = nation.getRanks().getHighestRank().getNode();
        }
        this.kingdom = null;
        this.rank = null;
        this.nationalRank = null;
        this.flying = false;
        this.autoClaim = null;
        this.chatChannel = KingdomsChatChannel.getGlobalChannel().getDataId();
        this.joinedAt = System.currentTimeMillis();
        this.landHistoryPosition = -1;
        this.landHistory.clear();
        this.claims.clear();
        this.readMails.clear();
        Player player = this.getPlayer();
        if (player != null) {
            this.disableFlying(player);
        }
    }

    @NotNull
    public SupportedLanguage getLanguage() {
        return this.language.isInstalled() ? this.language : (this.language = SupportedLanguage.EN);
    }

    public void setLanguage(SupportedLanguage language) {
        this.language = Objects.requireNonNull(language, "Players language cannot be null");
    }

    public KingdomJoinEvent joinKingdom(@NonNull Kingdom kingdom) {
        return this.joinKingdom(kingdom, null);
    }

    public KingdomJoinEvent joinKingdom(@NonNull Kingdom kingdom, @Nullable Consumer<KingdomJoinEvent> modifier) {
        Objects.requireNonNull(kingdom, "Cannot join a null kingdom");
        Validate.isTrue(!kingdom.getId().equals(this.kingdom), "Player is already in this kingdom");
        KingdomJoinEvent event = new KingdomJoinEvent(kingdom, this);
        if (modifier != null) {
            modifier.accept(event);
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.joinedAt = System.currentTimeMillis();
        this.kingdom = kingdom.getId();
        this.totalDonations = 0L;
        this.lastDonationAmount = 0L;
        kingdom.getMembers().add(this.id);
        return event;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KingdomPlayer)) {
            return false;
        }
        KingdomPlayer kp = (KingdomPlayer)obj;
        return FastUUID.equals(this.id, kp.id);
    }

    public @Nullable UUID getKingdomId() {
        return this.kingdom;
    }

    @Override
    public @NonNull UUID getDataKey() {
        return this.id;
    }

    public @NonNull KingdomsChatChannel getChatChannel() {
        return KingdomsChatChannel.fromId(this.chatChannel);
    }

    public @NonNull String getChatChannelId() {
        return this.chatChannel;
    }

    public PlayerChangeChatChannelEvent setChatChannel(@NonNull KingdomsChatChannel newChannel) {
        PlayerChangeChatChannelEvent event = new PlayerChangeChatChannelEvent(this, newChannel);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.chatChannel = event.getNewChannel().getDataId();
        }
        return event;
    }

    public @NonNull GroupResourcePointConvertEvent donate(long amount) {
        return this.donate(amount, null, null);
    }

    public @NonNull GroupResourcePointConvertEvent donate(Kingdom kingdom, long amount) {
        return this.donate(kingdom, amount, null, null);
    }

    public @NonNull GroupResourcePointConvertEvent donate(long amount, @Nullable List<ItemStack> items, @Nullable List<ItemStack> result) {
        return this.donate(this.getKingdom(), amount, items, result);
    }

    public @NonNull GroupResourcePointConvertEvent donate(Group group, long amount, @Nullable List<ItemStack> items, @Nullable List<ItemStack> result) {
        GroupResourcePointConvertEvent donateEvent = new GroupResourcePointConvertEvent(group, amount, this, items, result);
        Bukkit.getPluginManager().callEvent((Event)donateEvent);
        if (donateEvent.isCancelled()) {
            return donateEvent;
        }
        amount = donateEvent.getAmount();
        this.totalDonations += amount;
        long time = KingdomsConfig.ResourcePoints.LAST_DONATION_DURATION.getManager().getTimeMillis();
        long current = System.currentTimeMillis();
        long diff = current - this.lastDonationTime;
        if (diff >= time) {
            this.lastDonationTime = current;
            this.lastDonationAmount = amount;
        } else {
            this.lastDonationAmount += amount;
        }
        return donateEvent;
    }

    public boolean hasPermission(@NonNull KingdomPermission permission) {
        return this.hasAnyPermission(permission);
    }

    public boolean hasAnyPermission(KingdomPermission ... permissions) {
        if (this.admin) {
            return true;
        }
        Objects.requireNonNull(permissions, "Cannot check null permission");
        if (!this.hasKingdom()) {
            throw new NullPointerException("Cannot check permission of a player that is not in a kingdom: " + this.id + " | " + this.getOfflinePlayer().getName());
        }
        Rank rank = this.getRank();
        for (KingdomPermission permission : permissions) {
            if (permission == null || !rank.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNationPermission(@NonNull KingdomPermission permission) {
        if (this.admin) {
            return true;
        }
        Objects.requireNonNull(permission, "Cannot check null nation permission");
        if (!this.hasKingdom()) {
            throw new NullPointerException("Cannot check nation permission of a player that is not in a kingdom: " + this.id + " | " + this.getOfflinePlayer().getName());
        }
        return this.getNationRank().hasPermission(permission);
    }

    public void processLands(@NonNull Set<SimpleChunkLocation> lands, boolean claimed, boolean history) {
        if (history && KingdomsConfig.Claims.HISTORY_ENABLED.getManager().getBoolean()) {
            int limit = KingdomsConfig.Claims.HISTORY_LIMIT.getManager().getInt();
            this.landHistoryPosition = this.landHistory.size();
            if (this.landHistory.size() >= limit) {
                this.landHistory.removeFirst();
            }
            this.landHistory.add(Pair.of(lands, claimed));
        }
        if (claimed) {
            this.claims.addAll(lands);
        } else {
            this.claims.removeAll(lands);
        }
    }

    public long getLastDonationTime() {
        return this.lastDonationTime;
    }

    public void setLastDonationTime(long lastDonationTime) {
        this.lastDonationTime = lastDonationTime;
    }

    public @Nullable Pair<Set<SimpleChunkLocation>, Boolean> claimingHistory(boolean undo) {
        if (this.landHistory.isEmpty()) {
            return null;
        }
        if (this.landHistoryPosition <= -1 || this.landHistoryPosition >= this.landHistory.size()) {
            if (undo) {
                if (this.landHistoryPosition - 1 <= -1) {
                    return null;
                }
                --this.landHistoryPosition;
            } else {
                if (this.landHistoryPosition + 1 >= this.landHistory.size()) {
                    return null;
                }
                ++this.landHistoryPosition;
            }
            return this.landHistory.get(this.landHistoryPosition);
        }
        Pair<Set<SimpleChunkLocation>, Boolean> land = this.landHistory.get(this.landHistoryPosition);
        this.landHistoryPosition = undo ? --this.landHistoryPosition : ++this.landHistoryPosition;
        return land;
    }

    @NotNull
    public List<Pair<Set<SimpleChunkLocation>, Boolean>> getLandHistory() {
        return this.landHistory;
    }

    public @NonNull PlayerRankChangeEvent promote(KingdomPlayer byPlayer) {
        return this.jumpFromRank(byPlayer, this.getRank(), -1);
    }

    public @NonNull PlayerRankChangeEvent demote(KingdomPlayer byPlayer) {
        return this.jumpFromRank(byPlayer, this.getRank(), 1);
    }

    public @NonNull PlayerRankChangeEvent promoteNation() {
        return this.jumpToNationRank(this.getNationRank(), -1);
    }

    public @NonNull PlayerRankChangeEvent demoteNation() {
        return this.jumpToNationRank(this.getNationRank(), 1);
    }

    public @NonNull PlayerRankChangeEvent jumpFromRank(KingdomPlayer byPlayer, Rank rank, int jump) {
        Objects.requireNonNull(rank, "Cannot change rank of a player with no rank");
        int priority = rank.getPriority() + jump;
        Kingdom kingdom = this.getKingdom();
        Rank newRank = (Rank)kingdom.getRanks().getSortedRanks().get(priority);
        if (newRank == null) {
            throw new IllegalArgumentException("Cannot jump from rank '" + rank + "' in group '" + kingdom.getName() + "'  with maximum of " + kingdom.getRanks().size() + ' ' + "ranks (" + kingdom.getRanks().main.values().stream().map(x -> x.getName() + ':' + x.getPriority()).collect(Collectors.toList()) + '|' + kingdom.getRanks().sorted.entrySet().stream().map(x -> x.getKey() + " -> " + ((Rank)x.getValue()).getName() + ':' + ((Rank)x.getValue()).getPriority()).collect(Collectors.toList()) + ") to rank with priority: " + priority + ", jumped: " + jump);
        }
        if (newRank.isKing()) {
            throw new IllegalStateException("Jumping from rank " + rank.getNode() + " (" + rank.getPriority() + ") to king rank " + newRank.getNode() + " (" + newRank.getPriority() + ") (hint: Use Kingdom#setKing() instead)");
        }
        if (!kingdom.getRanks().has(rank.getNode())) {
            throw new IllegalArgumentException("The old rank '" + rank.getNode() + "' is not in kingdom: " + kingdom.getName());
        }
        PlayerRankChangeEvent event = new PlayerRankChangeEvent(rank, newRank, kingdom, this, byPlayer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.rank = newRank.getNode();
        return event;
    }

    public @NonNull PlayerRankChangeEvent jumpToNationRank(@NonNull Rank rank, int jump) {
        Objects.requireNonNull(rank, "Cannot change rank of a player with no national rank");
        int priority = rank.getPriority() + jump;
        Nation nation = this.getKingdom().getNation();
        Rank newRank = (Rank)nation.getRanks().getSortedRanks().get(priority);
        if (newRank == null) {
            throw new IllegalArgumentException("Cannot jump from rank '" + rank + "' in nation '" + nation.getName() + "' with maximum of " + nation.getRanks().size() + " ranks to rank with priority: " + priority);
        }
        if (newRank.isKing()) {
            throw new IllegalStateException("Jumping from national rank " + rank.getNode() + " (" + rank.getPriority() + ") to king rank " + newRank.getNode() + " (" + newRank.getPriority() + ") (hint: Use Kingdom#setKing() instead)");
        }
        if (!nation.getRanks().has(rank.getNode())) {
            throw new IllegalArgumentException("The old rank '" + rank.getNode() + "' is not in nation: " + nation.getName());
        }
        PlayerRankChangeEvent event = new PlayerRankChangeEvent(rank, newRank, nation, this, null);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.nationalRank = newRank.getNode();
        return event;
    }

    public @NonNull UUID getId() {
        return this.id;
    }

    @Override
    public @NonNull String getCompressedData() {
        return KingdomPlayer.compressUUID(this.kingdom) + this.chatChannel + (this.joinedAt == 0L ? "" : Long.valueOf(this.joinedAt)) + (this.lastDonationTime == 0L ? "" : Long.valueOf(this.lastDonationAmount)) + (this.lastDonationAmount == 0L ? "" : Long.valueOf(this.lastDonationAmount)) + (this.totalDonations == 0L ? "" : Long.valueOf(this.totalDonations)) + (this.power == 0.0 ? "" : Double.valueOf(this.power)) + (this.rank == null ? "" : this.rank) + (this.nationalRank == null ? "" : this.nationalRank) + (this.mapSize == null ? "" : Integer.valueOf(this.mapSize.getKey() + this.mapSize.getValue())) + this.language.ordinal() + KingdomPlayer.compressCollecton(this.invites.keySet(), KingdomsObject::compressUUID) + KingdomPlayer.compressCollecton(this.claims, SimpleChunkLocation::getCompressedData) + (this.markers ? Character.valueOf('1') : "") + (this.pvp ? Character.valueOf('1') : "") + (this.admin ? Character.valueOf('1') : "") + (this.spy ? Character.valueOf('1') : "") + (this.sneakMode ? Character.valueOf('1') : "") + this.compressMetadata();
    }

    public Boolean getAutoClaim() {
        return this.autoClaim;
    }

    public void setAutoClaim(Boolean autoClaim) {
        this.autoClaim = autoClaim;
    }

    public boolean isInvading() {
        return this.invasion != null;
    }

    @Override
    public @Nullable Invasion getInvasion() {
        return this.invasion;
    }

    public void setInvasion(@Nullable Invasion invasion) {
        this.invasion = invasion;
    }

    public @NonNull Set<UUID> getReadMails() {
        this.readMails.removeIf(read -> !KingdomsDataCenter.get().getMTG().exists(read));
        return this.readMails;
    }

    public void setReadMails(@NonNull Set<UUID> readMails) {
        this.readMails = readMails;
    }

    public void readMail(Mail mail) {
        Objects.requireNonNull(mail, "Cannot read null mail");
        this.readMails.add(mail.getId());
    }

    public long getJoinedAt() {
        return this.joinedAt;
    }

    public @NonNull Map<UUID, KingdomInvite> getInvites() {
        return this.invites;
    }

    public void setInvites(@NonNull Map<UUID, KingdomInvite> invites) {
        this.invites = invites;
    }

    public long getTotalDonations() {
        return this.totalDonations;
    }

    public void setTotalDonations(long totalDonations) {
        this.totalDonations = totalDonations;
    }

    public long getLastDonationAmount() {
        return this.lastDonationAmount;
    }

    public void setLastDonationAmount(long lastDonationAmount) {
        this.lastDonationAmount = lastDonationAmount;
    }

    public boolean isHigher(@NonNull KingdomPlayer kp) {
        return this.getRank().isHigherThan(kp.getRank());
    }

    public boolean isUsingMarkers() {
        return this.markers;
    }

    public void setUsingMarkers(boolean markers) {
        this.markers = markers;
    }

    public @NonNull Set<SimpleChunkLocation> getClaims() {
        return this.claims;
    }

    public void setClaims(@NonNull Set<SimpleChunkLocation> claims) {
        this.claims = claims;
    }

    public long getLastPowerCheckup() {
        return this.lastPowerCheckup;
    }

    public int getLandHistoryPosition() {
        return this.landHistoryPosition;
    }

    public void setLandHistoryPosition(int landHistoryPosition) {
        Validate.isTrue(landHistoryPosition < this.landHistory.size(), "Land history position cannot be bigger than the land history size.");
        this.landHistoryPosition = landHistoryPosition;
    }

    public boolean isAutoMap() {
        return this.autoMap;
    }

    public void setAutoMap(boolean autoMap) {
        this.autoMap = autoMap;
    }

    public @Nullable Pair<Integer, Integer> getMapSize() {
        return this.mapSize;
    }

    public void setMapSize(@Nullable Pair<Integer, Integer> mapSize) {
        this.mapSize = mapSize;
        if (KingdomsMap.SCOREBOARDS.containsKey(this.id) && this.getPlayer() != null) {
            this.buildMap().displayAsScoreboard();
        }
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public boolean isPvp() {
        return this.pvp;
    }

    public void setPvp(boolean pvp) {
        this.pvp = pvp;
    }

    public @Nullable String getNationRankNode() {
        return this.nationalRank;
    }

    public @Nullable Rank getNationRank() {
        Kingdom kingdom = this.getKingdom();
        if (kingdom == null) {
            return null;
        }
        Nation nation = kingdom.getNation();
        if (nation == null) {
            return null;
        }
        if (this.nationalRank == null) {
            return nation.getRanks().getLowestRank();
        }
        Rank rank = nation.getRanks().get(this.nationalRank);
        if (rank != null) {
            return rank;
        }
        rank = kingdom.getKingId().equals(this.id) ? nation.getRanks().getHighestRank() : nation.getRanks().getLowestRank();
        this.nationalRank = rank.getNode();
        return rank;
    }

    public PlayerRankChangeEvent setNationRank(@Nullable KingdomPlayer byPlayer, @Nullable Rank nationalRank) {
        Objects.requireNonNull(nationalRank, "Nation member rank cannot be null");
        Nation nation = this.getKingdom().getNation();
        if (!nation.getRanks().has(nationalRank.getNode())) {
            throw new IllegalArgumentException("The specified national rank '" + nationalRank.getNode() + "' is not in nation: " + nation.getName());
        }
        if (this.nationalRank != null) {
            Rank oldRank = nation.getRanks().get(this.nationalRank);
            PlayerRankChangeEvent event = new PlayerRankChangeEvent(oldRank, nationalRank, nation, this, byPlayer);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return event;
            }
        }
        this.nationalRank = nationalRank.getNode();
        return null;
    }

    public boolean isFlying() {
        return this.flying;
    }

    public void setFlying(boolean flying) {
        this.flying = flying;
    }

    public boolean toggleFlight() {
        this.flying = !this.flying;
        return this.flying;
    }

    public void disableFlying(@NonNull Player player) {
        this.flying = false;
        player.setFlying(false);
        player.setAllowFlight(false);
    }

    public KingdomsMap buildMap() {
        int width;
        int height;
        Player player = Objects.requireNonNull(this.getPlayer(), "Cannot show map to offline player");
        if (this.mapSize == null) {
            height = KingdomsConfig.Map.HEIGHT.getManager().getInt();
            width = KingdomsConfig.Map.WIDTH.getManager().getInt();
        } else {
            height = this.mapSize.getKey();
            width = this.mapSize.getValue();
        }
        return new KingdomsMap().forPlayer(player).setSize(height, width);
    }

    public boolean isSpy() {
        return this.spy;
    }

    public void setSpy(boolean spy) {
        this.spy = spy;
    }

    public void toggleSpy() {
        this.spy = !this.spy;
    }

    public @Nullable String getMarkersType() {
        return this.markersType;
    }

    public void setMarkersType(@Nullable String markersType) {
        this.markersType = markersType;
    }

    public double getPower() {
        this.updatePower(null);
        return this.power;
    }

    public double addPower(double power) {
        return this.setPower(this.power + power);
    }

    public double setPower(double power) {
        return this.setPower(power, false);
    }

    public double setPower(double power, boolean ignoreLimits) {
        this.lastPowerCheckup = System.currentTimeMillis();
        if (ignoreLimits) {
            this.power = power;
            return this.power;
        }
        OfflinePlayer player = this.getOfflinePlayer();
        double min = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_MIN.getManager().getString(), player, new Object[0]);
        double max = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_MAX.getManager().getString(), player, new Object[0]);
        this.power = Math.max(min, Math.min(max, power));
        return this.power;
    }

    public @NonNull Set<SimpleLocation> getProtectedBlocks() {
        return this.protectedBlocks;
    }

    public void setProtectedBlocks(@NonNull Set<SimpleLocation> protectedBlocks) {
        this.protectedBlocks = Objects.requireNonNull(protectedBlocks, "Player's protected blocks cannot be null");
    }

    public boolean isInSneakMode() {
        return this.sneakMode;
    }

    public void setSneakMode(boolean sneakMode) {
        this.sneakMode = sneakMode;
    }

    public void updatePower(@Nullable Boolean online) {
        if (!KingdomsConfig.Powers.POWER_ENABLED.getManager().getBoolean()) {
            return;
        }
        OfflinePlayer player = this.getOfflinePlayer();
        long now = System.currentTimeMillis();
        long passed = now - this.lastPowerCheckup;
        this.lastPowerCheckup = now;
        if (online == null) {
            online = player.isOnline();
        }
        if (online.booleanValue()) {
            long every = KingdomsConfig.Powers.POWER_PLAYER_REGENERATION_EVERY.getManager().getTimeMillis(TimeUnit.MINUTES);
            double div = (double)passed / (double)every;
            if (div > 0.0) {
                double charge = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_REGENERATION_CHARGE.getManager().getString(), player, new Object[0]);
                double max = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_MAX.getManager().getString(), player, new Object[0]);
                this.power += charge * div;
                this.power = Math.min(max, this.power);
            }
        } else {
            long every;
            double div;
            double lose;
            double limit = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_LOSS_OFFLINE_MIN.getManager().getString(), player, new Object[0]);
            if (this.power > limit && (lose = MathUtils.eval(KingdomsConfig.Powers.POWER_PLAYER_LOSS_OFFLINE_LOSE.getManager().getString(), player, new Object[0])) != 0.0 && (div = (double)passed / (double)(every = KingdomsConfig.Powers.POWER_PLAYER_LOSS_OFFLINE_EVERY.getManager().getTimeMillis(TimeUnit.DAYS).longValue())) > 0.0) {
                this.power += -lose * div;
                this.power = Math.max(limit, this.power);
            }
        }
    }

    @Override
    public int compareTo(@NonNull KingdomPlayer other) {
        if (!this.hasKingdom()) {
            return other.hasKingdom() ? -1 : 0;
        }
        Rank rank = this.getRank();
        if (!other.hasKingdom()) {
            return 1;
        }
        Rank otherRank = other.getRank();
        if (otherRank == null) {
            return rank == null ? 0 : 1;
        }
        int comparedRank = rank.compareTo(otherRank);
        if (comparedRank != 0) {
            return comparedRank;
        }
        return Long.compare(this.joinedAt, other.joinedAt);
    }

    public @NonNull Set<String> getMutedChannels() {
        return this.mutedChannels;
    }

    public void setMutedChannels(@NonNull Set<String> mutedChannels) {
        this.mutedChannels = mutedChannels;
    }
}

