/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.player;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPermission;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.internal.enumeration.OrderedSet;

public class Rank
implements Comparable<Rank>,
Cloneable {
    private static final RankMap DEFAULT_RANKS = new RankMap();
    public static boolean CUSTOM_RANKS;
    private transient @NonNull String node;
    private XMaterial material;
    private String name;
    private String color;
    private String symbol;
    private int priority;
    private int maxClaims;
    private @NonNull Set<KingdomPermission> permissions;

    public Rank(@NonNull String node, String name, String color, String symbol, XMaterial material, int priority, int maxClaims, Set<KingdomPermission> permissions) {
        Validate.isTrue(priority >= 0, "Rank priority must be greater than -1");
        this.node = Objects.requireNonNull(node, "Rank node cannot be null");
        this.name = name;
        this.color = color;
        this.symbol = symbol;
        this.priority = priority;
        this.maxClaims = maxClaims;
        this.material = Objects.requireNonNull(material, "Rank material cannot be null");
        this.permissions = Objects.requireNonNull(permissions, "Rank permissions cannot be null");
    }

    public static RankMap copyDefaults() {
        return DEFAULT_RANKS.clone();
    }

    public static void init() {
        DEFAULT_RANKS.clear();
        CUSTOM_RANKS = KingdomsConfig.Ranks.CUSTOM_RANKS_ENABLED.getManager().getBoolean();
        int priority = 0;
        for (String rank : KingdomsConfig.RANKS.getConfig().getConfigurationSection("ranks").getKeys(false)) {
            String name = KingdomsConfig.Ranks.NAME.getManager().withOption("rank", rank).getString();
            String color = KingdomsConfig.Ranks.COLOR.getManager().withOption("rank", rank).getString();
            String symbol = KingdomsConfig.Ranks.SYMBOL.getManager().withOption("rank", rank).getString();
            String matStr = KingdomsConfig.Ranks.MATERIAL.getManager().withOption("rank", rank).getString();
            XMaterial material = Strings.isNullOrEmpty((String)matStr) ? XMaterial.DIRT : XMaterial.matchXMaterial(matStr).orElse(XMaterial.DIRT);
            int maxClaims = KingdomsConfig.Ranks.MAX_CLAIMS.getManager().withOption("rank", rank).getInt();
            OrderedSet<KingdomPermission> permissions = new OrderedSet<KingdomPermission>(0);
            for (String permission : KingdomsConfig.Ranks.PERMISSIONS.getManager().withOption("rank", rank).getStringList()) {
                KingdomPermission perm = (KingdomPermission)Kingdoms.get().getPermissionRegistery().getRegistered(Namespace.fromString(permission));
                if (perm == null) {
                    MessageHandler.sendConsolePluginMessage("&cCould not find permission for default rank &e" + rank + " (" + name + ")&8: &e" + permission + " (" + perm + ')');
                    continue;
                }
                permissions.add(perm);
            }
            Objects.requireNonNull(color, () -> "Default rank color is not found for " + rank);
            Objects.requireNonNull(symbol, () -> "Default rank symbol is not found for " + rank);
            DEFAULT_RANKS.addOrReplace(new Rank(rank.toLowerCase(Locale.ENGLISH), name, color, symbol, material, priority, maxClaims, permissions));
            ++priority;
        }
    }

    public static RankMap getDefaultRanks() {
        return DEFAULT_RANKS;
    }

    public static @Nullable KingdomPlayer determineNextKing(@NonNull ArrayList<KingdomPlayer> members, @Nullable Comparator<KingdomPlayer> comparator) {
        Validate.notEmpty(members, "Members list cannot be null or empty");
        if (members.size() < 2) {
            return null;
        }
        if (comparator == null) {
            members.sort(KingdomPlayer::compareTo);
        } else {
            members.sort(comparator);
        }
        return members.get(1);
    }

    public static Rank getHighestRank() {
        return DEFAULT_RANKS.getHighestRank();
    }

    public static @NonNull Rank getLowestRank() {
        return DEFAULT_RANKS.getLowestRank();
    }

    public Set<KingdomPermission> copyPermissions() {
        return new OrderedSet<KingdomPermission>(this.permissions);
    }

    public boolean hasPermission(KingdomPermission permission) {
        return this.isKing() || this.permissions.contains(permission);
    }

    public @NonNull Rank clone() {
        return new Rank(this.node, this.name, this.color, this.symbol, this.material, this.priority, this.maxClaims, this.copyPermissions());
    }

    @Override
    public int compareTo(@NonNull Rank rank) {
        return Integer.compare(this.priority, rank.priority);
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public @NonNull String getCompressedData() {
        return this.node + this.name + this.symbol + (this.material == null ? "" : Integer.valueOf(this.material.ordinal())) + this.priority + this.maxClaims + KingdomsObject.compressCollecton(this.permissions, KingdomPermission::hashCode);
    }

    public String toString() {
        return "Rank:{node=" + this.node + ", name=" + this.name + ", priority=" + this.priority + ", color=" + this.color + ", symbol=" + this.symbol + ", maxClaims=" + this.maxClaims + ", material=" + this.material.name() + ", permissions=" + Arrays.toString(this.permissions.toArray()) + '}';
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rank)) {
            return false;
        }
        Rank rank = (Rank)obj;
        return this.node.equals(rank.node);
    }

    public boolean isHigherThan(@NonNull Rank rank) {
        Objects.requireNonNull(rank, "Cannot compare null rank");
        return this.priority < rank.priority;
    }

    public boolean isKing() {
        return this.priority == 0;
    }

    public @NonNull String getNode() {
        return this.node;
    }

    protected void setNode(@NonNull String node) {
        this.node = Objects.requireNonNull(node, "Rank node cannot be null");
    }

    public boolean canBePromoted() {
        return this.priority > 1;
    }

    public @Nullable XMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(XMaterial material) {
        this.material = material;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable String getColor() {
        return this.color;
    }

    public void setColor(@Nullable String color) {
        this.color = color;
    }

    public @Nullable String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nullable String symbol) {
        this.symbol = symbol;
    }

    public int getMaxClaims() {
        return this.maxClaims;
    }

    public void setMaxClaims(int maxClaims) {
        this.maxClaims = maxClaims;
    }

    public @IntRange(from=0L, to=0x7FFFFFFFL) int getPriority() {
        return this.priority;
    }

    protected void setPriority(@IntRange(from=0L, to=0x7FFFFFFFL) int priority) {
        Validate.isTrue(priority >= 0, "Rank priority must be greater than -1");
        this.priority = priority;
    }

    public @NonNull Set<KingdomPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(@NonNull Set<KingdomPermission> permissions) {
        this.permissions = Objects.requireNonNull(permissions, "Rank permissions cannot be null");
    }
}

