/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.data.DataManager;
import org.kingdoms.data.database.KingdomsDatabase;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.io.CloseableKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.ranges.RangesKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u000e\b\u0001\u0010\u0003*\b\u0012\u0004\u0012\u0002H\u00010\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0012J\u0013\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00028\u00002\u0006\u0010\u001f\u001a\u00020\tH\u0002\u00a2\u0006\u0002\u0010 J\u0015\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\"J\u001f\u0010!\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010#\u001a\u00020$H&\u00a2\u0006\u0002\u0010%J<\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010&2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010*J\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00010\u001aJ\u0013\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00028\u0001\u00a2\u0006\u0002\u0010.J\u001d\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00028\u00012\u0006\u0010/\u001a\u000200H&\u00a2\u0006\u0002\u00101J\u0014\u0010,\u001a\u00020\u00122\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00010&R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/kingdoms/data/database/flatfile/FlatFileDatabase;", "K", "", "T", "Lorg/kingdoms/constants/metadata/KingdomsObject;", "Lorg/kingdoms/data/database/KingdomsDatabase;", "extension", "", "folder", "Ljava/nio/file/Path;", "dataHandler", "Lorg/kingdoms/data/handlers/DataHandler;", "(Ljava/lang/String;Ljava/nio/file/Path;Lorg/kingdoms/data/handlers/DataHandler;)V", "getDataHandler", "()Lorg/kingdoms/data/handlers/DataHandler;", "maxKeys", "", "close", "", "delete", "key", "(Ljava/lang/Object;)V", "deleteAllData", "fileFromKey", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "getDataKeys", "", "hasData", "", "(Ljava/lang/Object;)Z", "keyFromFile", "path", "(Ljava/nio/file/Path;)Ljava/lang/Object;", "load", "(Ljava/lang/Object;)Lorg/kingdoms/constants/metadata/KingdomsObject;", "reader", "Ljava/io/BufferedReader;", "(Ljava/lang/Object;Ljava/io/BufferedReader;)Lorg/kingdoms/constants/metadata/KingdomsObject;", "", "keys", "to", "dataManager", "Lorg/kingdoms/data/DataManager;", "loadAllData", "save", "data", "(Lorg/kingdoms/constants/metadata/KingdomsObject;)V", "writer", "Ljava/io/BufferedWriter;", "(Lorg/kingdoms/constants/metadata/KingdomsObject;Ljava/io/BufferedWriter;)V", "core"})
public abstract class FlatFileDatabase<K, T extends KingdomsObject<K>>
implements KingdomsDatabase<K, T> {
    @NotNull
    private final String extension;
    @NotNull
    private final Path folder;
    @NotNull
    private final DataHandler<K, T> dataHandler;
    private int maxKeys;

    public FlatFileDatabase(@NotNull String extension, @NotNull Path folder, @NotNull DataHandler<K, T> dataHandler) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter(dataHandler, (String)"dataHandler");
        this.extension = extension;
        this.folder = folder;
        this.dataHandler = dataHandler;
        this.maxKeys = 10;
        if (!Files.exists(this.folder, new LinkOption[0])) {
            try {
                Files.createDirectories(this.folder, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public final DataHandler<K, T> getDataHandler() {
        return this.dataHandler;
    }

    private final K keyFromFile(Path path) {
        String str = ((Object)path.getFileName()).toString();
        String string = str.substring(0, str.length() - this.extension.length() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String removedExtension = string;
        return this.dataHandler.getIdHandler().fromString(removedExtension);
    }

    @NotNull
    public final Path fileFromKey(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Path path = this.folder.resolve(this.dataHandler.getIdHandler().toString(key) + '.' + this.extension);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"folder.resolve(dataHandl\u2026ing(key) + \".$extension\")");
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final T load(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Path file = this.fileFromKey(key);
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        Closeable closeable = Files.newBufferedReader(file, StandardCharsets.UTF_8);
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)reader, (String)"reader");
            T t = this.load(key, reader);
            return t;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public final Collection<T> load(@NotNull Collection<K> keys, @NotNull Collection<T> to, @NotNull DataManager<K, T> dataManager) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(to, (String)"to");
        Intrinsics.checkNotNullParameter(dataManager, (String)"dataManager");
        for (K key : keys) {
            T data;
            if (this.load(key) == null) continue;
            to.add(data);
            dataManager.load(data);
        }
        return to;
    }

    @Nullable
    public abstract T load(@NotNull K var1, @NotNull BufferedReader var2);

    public abstract void save(@NotNull T var1, @NotNull BufferedWriter var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void save(@NotNull T data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        String key = ((KingdomsObject)data).getDataKey() + '.' + this.extension;
        Path path = this.folder.resolve(key);
        try {
            Closeable closeable = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);
            Throwable throwable = null;
            try {
                BufferedWriter writer = (BufferedWriter)closeable;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
                this.save(data, writer);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public final void delete(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        try {
            Files.deleteIfExists(this.fileFromKey(key));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final boolean hasData(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return Files.exists(this.fileFromKey(key), new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final Collection<K> getDataKeys() {
        List paths = new ArrayList(this.maxKeys);
        Closeable closeable = Files.newDirectoryStream(this.folder);
        Throwable throwable = null;
        try {
            DirectoryStream fs = (DirectoryStream)closeable;
            boolean bl = false;
            for (Path path : fs) {
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                paths.add(this.keyFromFile(path));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.maxKeys = RangesKt.coerceAtLeast((int)paths.size(), (int)this.maxKeys);
        return paths;
    }

    @Override
    public final void deleteAllData() {
        try {
            Files.delete(this.folder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final Collection<T> loadAllData() {
        List loaded = new ArrayList(this.maxKeys);
        Closeable closeable = Files.newDirectoryStream(this.folder);
        Throwable throwable = null;
        try {
            DirectoryStream fs = (DirectoryStream)closeable;
            boolean bl = false;
            for (Path path : fs) {
                T data;
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                K key = this.keyFromFile(path);
                if (this.load(key) == null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    LinkOption[] linkOptionArray2 = new LinkOption[]{};
                    throw new IllegalStateException("Couldn't load bulk data " + key + " -> " + path + " -> " + Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) + " -> " + this.fileFromKey(key) + " -> " + Files.exists(this.fileFromKey(key), Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)));
                }
                loaded.add(data);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.maxKeys = RangesKt.coerceAtLeast((int)loaded.size(), (int)this.maxKeys);
        return loaded;
    }

    @Override
    public final void save(@NotNull Collection<T> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        for (KingdomsObject datum : data) {
            this.save(datum);
        }
    }

    @Override
    public final void close() {
    }
}

