/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.flatfile.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Objects;

public final class KingdomsGson {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().enableComplexMapKeySerialization().excludeFieldsWithModifiers(new int[]{128, 8}).create();
    private static final GsonContextImpl CONTEXT = new GsonContextImpl();

    private static JsonReader newJsonReader(Reader reader) {
        return new JsonReader(reader);
    }

    public static JsonElement fromString(String json) {
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(json));
            JsonElement element = KingdomsGson.parseReader(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException | NumberFormatException ex) {
            throw new JsonSyntaxException(ex);
        }
        catch (IOException ex) {
            throw new JsonIOException((Throwable)ex);
        }
    }

    private static JsonElement parseReader(JsonReader reader) throws JsonIOException, JsonSyntaxException {
        try {
            return Streams.parse((JsonReader)reader);
        }
        catch (OutOfMemoryError | StackOverflowError ex) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", (Throwable)ex);
        }
    }

    public static String toString(JsonElement element) {
        Objects.requireNonNull(element);
        try {
            StringWriter stringWriter = new StringWriter();
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            jsonWriter.setLenient(false);
            jsonWriter.setSerializeNulls(false);
            jsonWriter.setHtmlSafe(false);
            Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
            return stringWriter.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static JsonWriter newJsonWriter(Writer writer) throws IOException {
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.setIndent("  ");
        jsonWriter.setLenient(false);
        jsonWriter.setSerializeNulls(false);
        jsonWriter.setHtmlSafe(false);
        return jsonWriter;
    }

    public static String toJson(Object src) {
        return GSON.toJson(src);
    }

    public static void toJson(JsonObject object, Appendable writer) throws IOException {
        JsonWriter jsonWriter = KingdomsGson.newJsonWriter(Streams.writerForAppendable((Appendable)writer));
        Streams.write((JsonElement)object, (JsonWriter)jsonWriter);
    }

    private static void assertFullConsumption(Object obj, JsonReader reader) {
        try {
            if (obj != null && reader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
    }

    public static JsonObject parse(Reader json) throws JsonIOException, JsonSyntaxException {
        JsonObject object;
        JsonReader reader = KingdomsGson.newJsonReader(json);
        reader.setLenient(false);
        try {
            reader.peek();
            object = (JsonObject)Streams.parse((JsonReader)reader);
        }
        catch (IllegalStateException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IOException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (AssertionError e) {
            throw new AssertionError("AssertionError (GSON 2.8.9): " + ((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
        }
        KingdomsGson.assertFullConsumption(object, reader);
        return object;
    }

    private static JsonElement parse(JsonReader reader) throws JsonParseException {
        boolean isEmpty = true;
        try {
            reader.peek();
            isEmpty = false;
            return (JsonElement)TypeAdapters.JSON_ELEMENT.read(reader);
        }
        catch (EOFException e) {
            if (isEmpty) {
                return JsonNull.INSTANCE;
            }
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
        catch (IOException e) {
            throw new JsonIOException((Throwable)e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException((Throwable)e);
        }
    }

    private static final class GsonContextImpl
    implements JsonSerializationContext,
    JsonDeserializationContext {
        private GsonContextImpl() {
        }

        public JsonElement serialize(Object src) {
            return GSON.toJsonTree(src);
        }

        public JsonElement serialize(Object src, Type typeOfSrc) {
            return GSON.toJsonTree(src, typeOfSrc);
        }

        public <R> R deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
            return (R)GSON.fromJson(json, typeOfT);
        }
    }
}

