/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLFlatFileConnectionProvider;
import org.kingdoms.data.database.sql.SQLHikariConnectionProvider;
import org.kingdoms.libs.hikari.HikariDataSource;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.KLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH&J\b\u0010\u000b\u001a\u00020\fH&J\u0015\u0010\r\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/data/database/sql/SQLConnectionProvider;", "", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "tablePrefix", "", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;)V", "getTablePrefix", "()Ljava/lang/String;", "close", "", "getConnection", "Ljava/sql/Connection;", "testTemporaryLibCreation", "testTemporaryLibCreation$core", "Companion", "core"})
public abstract class SQLConnectionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tablePrefix;
    @JvmField
    @NotNull
    public static final String TABLE_PREFIX = KingdomsConfig.DATABASE_TABLE_PREFIX.getString() + '_';
    @Nullable
    private static SQLConnectionProvider DEFAULT_PROVIDER;

    public SQLConnectionProvider(@NotNull DatabaseType databaseType, @NotNull String tablePrefix) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)tablePrefix, (String)"tablePrefix");
        this.tablePrefix = tablePrefix;
    }

    @NotNull
    public final String getTablePrefix() {
        return this.tablePrefix;
    }

    @NotNull
    public abstract Connection getConnection();

    public abstract void close();

    public final void testTemporaryLibCreation$core(@NotNull DatabaseType databaseType) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Object object = new DatabaseType[]{DatabaseType.SQLite, DatabaseType.H2};
        if (ArraysKt.contains((Object[])object, (Object)((Object)databaseType))) {
            Object $this$testTemporaryLibCreation_u24lambda_u2d0 = object = new File(System.getProperty("java.io.tmpdir"));
            boolean bl = false;
            if (!(((File)$this$testTemporaryLibCreation_u24lambda_u2d0).exists() && ((File)$this$testTemporaryLibCreation_u24lambda_u2d0).isDirectory() && ((File)$this$testTemporaryLibCreation_u24lambda_u2d0).canRead() && ((File)$this$testTemporaryLibCreation_u24lambda_u2d0).canWrite())) {
                KLogger.error("A problem has occurred for with java.io.tmpdir " + ((File)$this$testTemporaryLibCreation_u24lambda_u2d0).exists() + " | " + ((File)$this$testTemporaryLibCreation_u24lambda_u2d0).isDirectory() + " | " + ((File)$this$testTemporaryLibCreation_u24lambda_u2d0).canRead() + " | " + ((File)$this$testTemporaryLibCreation_u24lambda_u2d0).canWrite());
            }
        }
    }

    @JvmStatic
    @NotNull
    public static final SQLConnectionProvider getDefaultProvider() {
        return Companion.getDefaultProvider();
    }

    @JvmStatic
    public static final void setDefaultProviderIfNull(@NotNull Path path, @NotNull DatabaseType databaseType) {
        Companion.setDefaultProviderIfNull(path, databaseType);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\u0004H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/data/database/sql/SQLConnectionProvider$Companion;", "", "()V", "DEFAULT_PROVIDER", "Lorg/kingdoms/data/database/sql/SQLConnectionProvider;", "getDEFAULT_PROVIDER$annotations", "TABLE_PREFIX", "", "getDefaultProvider", "setDefaultProviderIfNull", "", "path", "Ljava/nio/file/Path;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getDEFAULT_PROVIDER$annotations() {
        }

        @JvmStatic
        @NotNull
        public final SQLConnectionProvider getDefaultProvider() {
            SQLConnectionProvider sQLConnectionProvider = DEFAULT_PROVIDER;
            if (sQLConnectionProvider == null) {
                throw new IllegalStateException("Default provider not initialized yet");
            }
            return sQLConnectionProvider;
        }

        @JvmStatic
        public final void setDefaultProviderIfNull(@NotNull Path path, @NotNull DatabaseType databaseType) {
            SQLConnectionProvider sQLConnectionProvider;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
            if (DEFAULT_PROVIDER != null) {
                return;
            }
            if (databaseType == DatabaseType.SQLite || databaseType == DatabaseType.H2) {
                String extension = databaseType == DatabaseType.H2 ? "" : ".db";
                Path path2 = path.resolve("data" + extension);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"path.resolve(\"data$extension\")");
                sQLConnectionProvider = new SQLFlatFileConnectionProvider(databaseType, TABLE_PREFIX, path2);
            } else {
                sQLConnectionProvider = new SQLHikariConnectionProvider(databaseType, TABLE_PREFIX, new HikariDataSource());
            }
            DEFAULT_PROVIDER = sQLConnectionProvider;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

