/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.NonClosableConnection;
import org.kingdoms.data.database.sql.SQLConnectionProvider;
import org.kingdoms.dependencies.Dependency;
import org.kingdoms.dependencies.classpath.IsolatedClassLoader;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.Kingdoms;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/data/database/sql/SQLFlatFileConnectionProvider;", "Lorg/kingdoms/data/database/sql/SQLConnectionProvider;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "tablePrefix", "", "file", "Ljava/nio/file/Path;", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;Ljava/nio/file/Path;)V", "connection", "Lorg/kingdoms/data/database/sql/NonClosableConnection;", "close", "", "getConnection", "core"})
public final class SQLFlatFileConnectionProvider
extends SQLConnectionProvider {
    @NotNull
    private final Path file;
    @NotNull
    private final NonClosableConnection connection;

    public SQLFlatFileConnectionProvider(@NotNull DatabaseType databaseType, @NotNull String tablePrefix, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)tablePrefix, (String)"tablePrefix");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(databaseType, tablePrefix);
        this.file = file;
        DatabaseType[] databaseTypeArray = new DatabaseType[]{DatabaseType.SQLite, DatabaseType.H2};
        if (!ArraysKt.contains((Object[])databaseTypeArray, (Object)((Object)databaseType))) {
            boolean $i$a$-require-SQLFlatFileConnectionProvider$22 = false;
            String $i$a$-require-SQLFlatFileConnectionProvider$22 = "Invalid SQL type for flat file: " + (Object)((Object)databaseType);
            throw new IllegalArgumentException($i$a$-require-SQLFlatFileConnectionProvider$22.toString());
        }
        this.testTemporaryLibCreation$core(databaseType);
        IsolatedClassLoader isolatedClassLoader = Kingdoms.get().getDependencyManager().obtainClassLoaderWith((Set<Dependency>)EnumSet.of((Enum)ArraysKt.first((Object[])databaseType.getDependencies())));
        Intrinsics.checkNotNullExpressionValue((Object)isolatedClassLoader, (String)"get().dependencyManager.\u2026pe.dependencies.first()))");
        IsolatedClassLoader classLoader = isolatedClassLoader;
        try {
            Connection connection;
            String filePath = ((Object)this.file.toAbsolutePath()).toString();
            String jdbc = databaseType == DatabaseType.SQLite ? "org.sqlite.jdbc4.JDBC4Connection" : "org.h2.jdbc.JdbcConnection";
            Class<?> clazz = classLoader.loadClass(jdbc);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"classLoader.loadClass(jdbc)");
            Class<?> connectionClass = clazz;
            if (databaseType == DatabaseType.SQLite) {
                Class[] classArray = new Class[]{String.class, String.class, Properties.class};
                Constructor<?> ctor = connectionClass.getConstructor(classArray);
                Object[] objectArray = new Object[]{"jdbc:sqlite:" + filePath, filePath, new Properties()};
                Object obj = ctor.newInstance(objectArray);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Connection");
                connection = (Connection)obj;
            } else {
                Class[] classArray = new Class[]{String.class, Properties.class, String.class, Object.class, Boolean.TYPE};
                Constructor<?> ctor = connectionClass.getConstructor(classArray);
                Object[] objectArray = new Object[]{"jdbc:h2:" + filePath, new Properties(), null, null, false};
                Object obj = ctor.newInstance(objectArray);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Connection");
                connection = (Connection)obj;
            }
            this.connection = new NonClosableConnection(connection);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @NotNull
    public NonClosableConnection getConnection() {
        return this.connection;
    }

    @Override
    public void close() {
        this.connection.shutdown();
    }
}

