/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.data.database.sql.DatabaseProperties;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLConnectionProvider;
import org.kingdoms.libs.hikari.HikariConfig;
import org.kingdoms.libs.hikari.HikariDataSource;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.main.KLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kingdoms/data/database/sql/SQLHikariConnectionProvider;", "Lorg/kingdoms/data/database/sql/SQLConnectionProvider;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "tablePrefix", "", "hikari", "Lorg/kingdoms/libs/hikari/HikariDataSource;", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/lang/String;Lcom/zaxxer/hikari/HikariDataSource;)V", "close", "", "getConnection", "Ljava/sql/Connection;", "core"})
public final class SQLHikariConnectionProvider
extends SQLConnectionProvider {
    @NotNull
    private final HikariDataSource hikari;

    public SQLHikariConnectionProvider(@NotNull DatabaseType databaseType, @NotNull String tablePrefix, @NotNull HikariDataSource hikari) {
        HikariDataSource hikariDataSource;
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter((Object)tablePrefix, (String)"tablePrefix");
        Intrinsics.checkNotNullParameter((Object)hikari, (String)"hikari");
        super(databaseType, tablePrefix);
        this.hikari = hikari;
        this.hikari.setDataSourceClassName(databaseType.getDataSourceClassName());
        databaseType.applyProperties((HikariConfig)this.hikari, DatabaseProperties.Companion.defaults(databaseType));
        HikariDataSource $this$_init__u24lambda_u2d1 = hikariDataSource = this.hikari;
        boolean bl = false;
        if (KLogger.isDebugging()) {
            $this$_init__u24lambda_u2d1.setLeakDetectionThreshold(Duration.ofSeconds(30L).toMillis());
        }
        $this$_init__u24lambda_u2d1.setPoolName("kingdoms-hikari");
        $this$_init__u24lambda_u2d1.setMaximumPoolSize(KingdomsConfig.DATABASE_POOL_SETTINGS_SIZE_MAX.getInt());
        $this$_init__u24lambda_u2d1.setMinimumIdle(KingdomsConfig.DATABASE_POOL_SETTINGS_MINIMUM_IDLE.getInt());
        $this$_init__u24lambda_u2d1.setMaxLifetime((long)KingdomsConfig.DATABASE_POOL_SETTINGS_MAXIMUM_LIFETIME.getInt());
        $this$_init__u24lambda_u2d1.setKeepaliveTime((long)KingdomsConfig.DATABASE_POOL_SETTINGS_KEEPALIVE_TIME.getInt());
        $this$_init__u24lambda_u2d1.setConnectionTimeout((long)KingdomsConfig.DATABASE_POOL_SETTINGS_CONNECTION_TIMEOUT.getInt());
    }

    @Override
    @NotNull
    public Connection getConnection() {
        Connection connection;
        try {
            connection = this.hikari.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        Connection connection2 = connection;
        if (connection2 == null) {
            boolean bl = false;
            String string = "Unable to get a connection from the pool.";
            throw new IllegalStateException(string.toString());
        }
        return connection2;
    }

    @Override
    public void close() {
        this.hikari.close();
    }
}

