/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.database.sql.statements.setters;

import com.google.gson.JsonElement;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.kingdoms.data.database.flatfile.json.KingdomsGson;
import org.kingdoms.data.database.sql.DatabaseType;
import org.kingdoms.data.database.sql.SQLDatabase;
import org.kingdoms.data.database.sql.statements.setters.SimplePreparedStatement;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.postgresql.util.PGobject;
import org.kingdoms.main.KLogger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u0010J$\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0006H\u0002J\u000e\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0006J\u0016\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0010H\u0002J\u0006\u0010%\u001a\u00020\u0010J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u0006H\u0002J\b\u0010(\u001a\u00020\u0010H\u0002J\b\u0010)\u001a\u00020\u0010H\u0002J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\nH\u0016J\u0018\u0010,\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\u0006\u0010+\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\u0006\u0010+\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0007H\u0016J\u0018\u00101\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u000102J\u0018\u00103\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\u0006\u0010+\u001a\u000204H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0002J\u001a\u00105\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u00106\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00062\b\u0010+\u001a\u0004\u0018\u000107H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\f\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u00068"}, d2={"Lorg/kingdoms/data/database/sql/statements/setters/PreparedNamedSetterStatement;", "Lorg/kingdoms/data/database/sql/statements/setters/SimplePreparedStatement;", "databaseType", "Lorg/kingdoms/data/database/sql/DatabaseType;", "associateNamedData", "", "", "", "(Lorg/kingdoms/data/database/sql/DatabaseType;Ljava/util/Map;)V", "batch", "", "initialized", "operations", "", "Lorg/kingdoms/libs/kotlin/Pair;", "Lorg/kingdoms/libs/kotlin/Function1;", "", "setParameters", "", "statement", "Ljava/sql/PreparedStatement;", "getStatement", "()Ljava/sql/PreparedStatement;", "setStatement", "(Ljava/sql/PreparedStatement;)V", "addBatch", "addOperation", "parameter", "operation", "addParameter", "parameterName", "addParameterIfNotExist", "buildStatement", "table", "connection", "Ljava/sql/Connection;", "checkInitialized", "execute", "getIndex", "name", "nullRemainingParameters", "resetBatch", "setBoolean", "value", "setDouble", "", "setFloat", "", "setInt", "setJson", "Lcom/google/gson/JsonElement;", "setLong", "", "setString", "setUUID", "Ljava/util/UUID;", "core"})
public final class PreparedNamedSetterStatement
implements SimplePreparedStatement {
    @NotNull
    private final DatabaseType databaseType;
    @NotNull
    private final List<Pair<String, Function1<Integer, Unit>>> operations;
    public PreparedStatement statement;
    private boolean initialized;
    private boolean batch;
    @NotNull
    private final Map<String, Integer> associateNamedData;
    @NotNull
    private Set<String> setParameters;

    public PreparedNamedSetterStatement(@NotNull DatabaseType databaseType, @NotNull Map<String, Integer> associateNamedData) {
        Intrinsics.checkNotNullParameter((Object)((Object)databaseType), (String)"databaseType");
        Intrinsics.checkNotNullParameter(associateNamedData, (String)"associateNamedData");
        this.databaseType = databaseType;
        this.operations = new ArrayList(30);
        this.associateNamedData = new LinkedHashMap<String, Integer>(associateNamedData);
        this.setParameters = new HashSet();
    }

    @NotNull
    public final PreparedStatement getStatement() {
        PreparedStatement preparedStatement = this.statement;
        if (preparedStatement != null) {
            return preparedStatement;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"statement");
        return null;
    }

    public final void setStatement(@NotNull PreparedStatement preparedStatement) {
        Intrinsics.checkNotNullParameter((Object)preparedStatement, (String)"<set-?>");
        this.statement = preparedStatement;
    }

    public final void addParameterIfNotExist(@NotNull String parameterName) {
        Intrinsics.checkNotNullParameter((Object)parameterName, (String)"parameterName");
        if (!this.associateNamedData.containsKey(parameterName)) {
            this.addParameter(parameterName);
        }
    }

    private final void addParameter(String parameterName) {
        this.associateNamedData.put(parameterName, this.associateNamedData.size() + 1);
    }

    private final void addOperation(String parameter, Function1<? super Integer, Unit> operation) {
        this.setParameters.add(parameter);
        if (this.initialized) {
            operation.invoke((Object)this.getIndex(parameter));
        } else {
            this.operations.add((Pair<String, Function1<Integer, Unit>>)TuplesKt.to((Object)parameter, operation));
        }
    }

    private final void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Statement not built yet");
        }
    }

    private final int getIndex(String name) {
        Integer n = this.associateNamedData.get(name);
        if (n == null) {
            throw new IllegalStateException("Unknown parameter index for: " + name + " (" + this.associateNamedData + ')');
        }
        return n;
    }

    public final void buildStatement(@NotNull String table, @NotNull Connection connection) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        if (this.initialized) {
            return;
        }
        StringJoiner parameterNamesJoiner = new StringJoiner(", ");
        StringJoiner preparedParameterJoiner = new StringJoiner(", ");
        for (String key : this.associateNamedData.keySet()) {
            parameterNamesJoiner.add('`' + key + '`');
            preparedParameterJoiner.add("?");
        }
        Iterator<String> iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            String paramName = (String)((Pair)iterator.next()).component1();
            if (this.associateNamedData.containsKey(paramName)) continue;
            this.addParameter(paramName);
            parameterNamesJoiner.add('`' + paramName + '`');
            preparedParameterJoiner.add("?");
        }
        String string = parameterNamesJoiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parameterNamesJoiner.toString()");
        String string2 = preparedParameterJoiner.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"preparedParameterJoiner.toString()");
        String query = this.databaseType.upsertStatement(table, string, string2);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"connection.prepareStatement(query)");
            this.setStatement(preparedStatement);
        }
        catch (Throwable e) {
            KLogger.error("Failed to build setter statement with query: " + query);
            throw e;
        }
        this.initialized = true;
    }

    private final void setParameters() {
        for (Pair<String, Function1<Integer, Unit>> pair : this.operations) {
            String parameterName = (String)pair.component1();
            Function1 operation = (Function1)pair.component2();
            int index = this.getIndex(parameterName);
            operation.invoke((Object)index);
        }
    }

    public final void execute() {
        this.checkInitialized();
        if (this.batch) {
            this.getStatement().executeBatch();
        } else {
            this.setParameters();
            this.nullRemainingParameters();
            this.getStatement().execute();
        }
        this.getStatement().close();
    }

    private final void resetBatch() {
        this.getStatement().clearParameters();
    }

    private final void nullRemainingParameters() {
        Map<String, Integer> $this$filterKeys$iv = this.associateNamedData;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, Integer> result$iv = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry$iv : $this$filterKeys$iv.entrySet()) {
            String x = entry$iv.getKey();
            boolean bl = false;
            if (!(!this.setParameters.contains(x))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            this.getStatement().setObject(((Number)entry.getValue()).intValue(), null);
        }
        this.setParameters = new HashSet();
    }

    public final void addBatch() {
        this.checkInitialized();
        if (!this.batch) {
            this.setParameters();
        }
        this.nullRemainingParameters();
        this.getStatement().addBatch();
        this.resetBatch();
        this.batch = true;
    }

    @Override
    public void setString(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
            final /* synthetic */ PreparedNamedSetterStatement this$0;
            final /* synthetic */ String $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(int index) {
                this.this$0.getStatement().setString(index, this.$value);
            }
        }));
    }

    @Override
    public void setInt(@NotNull String name, int value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
            final /* synthetic */ PreparedNamedSetterStatement this$0;
            final /* synthetic */ int $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(int index) {
                this.this$0.getStatement().setInt(index, this.$value);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public final void setJson(@NotNull String name, @Nullable JsonElement value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        switch (WhenMappings.$EnumSwitchMapping$0[this.databaseType.ordinal()]) {
            case 1: {
                this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
                    final /* synthetic */ PreparedNamedSetterStatement this$0;
                    final /* synthetic */ JsonElement $value;
                    {
                        this.this$0 = $receiver;
                        this.$value = $value;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(int index) {
                        byte[] byArray;
                        PreparedStatement preparedStatement = this.this$0.getStatement();
                        int n = index;
                        JsonElement jsonElement = this.$value;
                        if (jsonElement != null) {
                            void it;
                            JsonElement jsonElement2 = jsonElement;
                            int n2 = n;
                            PreparedStatement preparedStatement2 = preparedStatement;
                            boolean bl = false;
                            String string = KingdomsGson.toString((JsonElement)it);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(it)");
                            String string2 = string;
                            Charset charset = StandardCharsets.UTF_8;
                            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                            byte[] byArray2 = string2.getBytes(charset);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
                            byte[] byArray3 = byArray2;
                            preparedStatement = preparedStatement2;
                            n = n2;
                            byArray = byArray3;
                        } else {
                            byArray = null;
                        }
                        preparedStatement.setBytes(n, byArray);
                    }
                }));
                break;
            }
            case 2: {
                this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(value, this){
                    final /* synthetic */ JsonElement $value;
                    final /* synthetic */ PreparedNamedSetterStatement this$0;
                    {
                        this.$value = $value;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(int index) {
                        PGobject jsonObject = new PGobject();
                        jsonObject.setType("json");
                        jsonObject.setValue(this.$value == null ? null : KingdomsGson.toString(this.$value));
                        this.this$0.getStatement().setObject(index, jsonObject);
                    }
                }));
                break;
            }
            default: {
                String string;
                PreparedNamedSetterStatement preparedNamedSetterStatement = this;
                String string2 = name;
                JsonElement jsonElement = value;
                if (jsonElement != null) {
                    void it;
                    JsonElement jsonElement2 = jsonElement;
                    String string3 = string2;
                    PreparedNamedSetterStatement preparedNamedSetterStatement2 = preparedNamedSetterStatement;
                    boolean bl = false;
                    String string4 = KingdomsGson.toString((JsonElement)it);
                    preparedNamedSetterStatement = preparedNamedSetterStatement2;
                    string2 = string3;
                    string = string4;
                } else {
                    string = null;
                }
                preparedNamedSetterStatement.setString(string2, string);
            }
        }
    }

    @Override
    public void setFloat(@NotNull String name, float value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
            final /* synthetic */ PreparedNamedSetterStatement this$0;
            final /* synthetic */ float $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(int index) {
                this.this$0.getStatement().setFloat(index, this.$value);
            }
        }));
    }

    @Override
    public void setLong(@NotNull String name, long value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
            final /* synthetic */ PreparedNamedSetterStatement this$0;
            final /* synthetic */ long $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(int index) {
                this.this$0.getStatement().setLong(index, this.$value);
            }
        }));
    }

    @Override
    public void setBoolean(@NotNull String name, boolean value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
            final /* synthetic */ PreparedNamedSetterStatement this$0;
            final /* synthetic */ boolean $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(int index) {
                this.this$0.getStatement().setBoolean(index, this.$value);
            }
        }));
    }

    @Override
    public void setDouble(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
            final /* synthetic */ PreparedNamedSetterStatement this$0;
            final /* synthetic */ double $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(int index) {
                this.this$0.getStatement().setDouble(index, this.$value);
            }
        }));
    }

    @Override
    public void setUUID(@NotNull String name, @Nullable UUID value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addOperation(name, (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(this, value){
            final /* synthetic */ PreparedNamedSetterStatement this$0;
            final /* synthetic */ UUID $value;
            {
                this.this$0 = $receiver;
                this.$value = $value;
                super(1);
            }

            public final void invoke(int index) {
                if (PreparedNamedSetterStatement.access$getDatabaseType$p(this.this$0) == DatabaseType.PostgreSQL) {
                    this.this$0.getStatement().setObject(index, this.$value);
                } else {
                    this.this$0.getStatement().setBytes(index, this.$value == null ? null : SQLDatabase.asBytes(this.$value));
                }
            }
        }));
    }

    public static final /* synthetic */ DatabaseType access$getDatabaseType$p(PreparedNamedSetterStatement $this) {
        return $this.databaseType;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            nArray[DatabaseType.H2.ordinal()] = 1;
            nArray[DatabaseType.PostgreSQL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

