/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.mails.MailRecipientType;
import org.kingdoms.data.database.dataprovider.DataSetter;
import org.kingdoms.data.database.dataprovider.SQLDataHandlerProperties;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.dataprovider.StdIdDataType;
import org.kingdoms.data.handlers.DataHandler;
import org.kingdoms.data.handlers.DataHandlerMetadata;
import org.kingdoms.libs.jetbrains.annotations.NotNull;

public final class DataHandlerMail
extends DataHandler<UUID, Mail> {
    public DataHandlerMail() {
        super(StdIdDataType.UUID, new SQLDataHandlerProperties(new String[0]));
    }

    @Override
    public void save(@NotNull SectionableDataSetter provider, Mail data) {
        provider.setUUID("fromGroup", data.getFromGroup());
        provider.setUUID("sender", data.getSender());
        provider.setUUID("inReplyTo", data.getInReplyTo());
        provider.setString("subject", data.getSubject());
        provider.setLong("sent", data.getTime());
        provider.get("recipients").setMap(data.getRecipients(), (key, keyProvider, value) -> {
            keyProvider.setUUID((UUID)key);
            keyProvider.getValueProvider().setString(value.name());
        });
        provider.get("message").setCollection(data.getMessage(), DataSetter::setString);
        DataHandlerMetadata.serializeMetadata(provider, data);
    }

    @Override
    public Mail load(@NotNull SectionableDataGetter provider, UUID id) {
        UUID fromGroup = provider.get("fromGroup").asUUID();
        UUID sender = provider.get("sender").asUUID();
        UUID inReplyTo = provider.get("inReplyTo").asUUID();
        String subject = provider.getString("subject");
        long sent = provider.getLong("sent");
        HashMap recipients = provider.get("recipients").asMap(new HashMap(), (map, key, value) -> map.put(key.asUUID(), MailRecipientType.valueOf(value.asString())));
        List message = provider.get("message").asCollection(new ArrayList(), (list2, element) -> list2.add(element.asString()));
        Mail mail = new Mail(id, fromGroup, sender, subject, recipients, message, inReplyTo);
        DataHandlerMetadata.deserializeMetadata(provider, mail);
        return mail;
    }
}

