/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.data.handlers;

import java.util.HashMap;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.metadata.KingdomMetadata;
import org.kingdoms.constants.metadata.KingdomMetadataHandler;
import org.kingdoms.constants.metadata.KingdomsObject;
import org.kingdoms.constants.metadata.StandardKingdomMetadataHandler;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionCreatableDataSetter;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.main.Kingdoms;

public final class DataHandlerMetadata {
    public static void deserializeMetadata(SectionableDataGetter provider, KingdomsObject<?> container) {
        HashMap metadata = provider.get("metadata").asMap(new HashMap(), (map, key, value) -> {
            String string = key.asString((Function0<String>)((Function0)() -> {
                throw new UnsupportedOperationException();
            }));
            Namespace ns = Namespace.fromString(string);
            KingdomMetadataHandler metaNS = (KingdomMetadataHandler)Kingdoms.get().getMetadataRegistry().getRegistered(ns);
            if (metaNS == null) {
                metaNS = new StandardKingdomMetadataHandler(ns);
            }
            try {
                KingdomMetadata data = metaNS.deserialize(container, new DeserializationContext<SectionableDataGetter>((SectionableDataGetter)value));
                map.put(metaNS, data);
            }
            catch (Throwable ex) {
                throw new RuntimeException("Error while deserializing metadata with namespace: " + string + " -> " + ns + " -> " + metaNS, ex);
            }
        });
        container.setMetadata(metadata);
    }

    public static void serializeMetadata(SectionableDataSetter provider, KingdomsObject<?> obj) {
        provider.get("metadata").setMap(obj.getMetadata(), (key, keyProvider, value) -> {
            if (!value.shouldSave(obj)) {
                return;
            }
            keyProvider.setString(key.getNamespace().asNormalizedString());
            try {
                value.serialize(obj, new SerializationContext<SectionCreatableDataSetter>(keyProvider.getValueProvider()));
            }
            catch (Throwable ex) {
                throw new RuntimeException("Error while serializing metadata with namespace: " + key.getNamespace(), ex);
            }
        });
    }
}

