/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.invasion;

import java.util.Objects;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.kingdoms.abstraction.InvasionOperator;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.managers.invasions.Invasion;

public class KingdomInvadeAttackEvent
extends KingdomsEvent
implements InvasionOperator {
    private static final HandlerList handlers = new HandlerList();
    private final Invasion invasion;
    private final EntityDamageByEntityEvent damageEvent;

    public KingdomInvadeAttackEvent(Invasion invasion, EntityDamageByEntityEvent damageEvent) {
        Objects.requireNonNull(invasion, "Invasion cannot be null");
        Objects.requireNonNull(damageEvent, "Main damage event cannot be null");
        this.invasion = invasion;
        this.damageEvent = damageEvent;
    }

    public static @NonNull HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isAttackerChampion() {
        return this.damageEvent.getEntity() instanceof Player;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @Override
    public Invasion getInvasion() {
        return this.invasion;
    }

    public EntityDamageByEntityEvent getDamageEvent() {
        return this.damageEvent;
    }

    @NotNull
    public Entity getDamager() {
        return this.damageEvent.getDamager();
    }

    public double getDamage() {
        return this.damageEvent.getDamage();
    }

    public void setDamage(double damage) {
        this.damageEvent.setDamage(damage);
    }

    public final double getFinalDamage() {
        return this.damageEvent.getFinalDamage();
    }

    public boolean isCancelled() {
        return this.damageEvent.isCancelled();
    }

    public void setCancelled(boolean cancel) {
        this.damageEvent.setCancelled(cancel);
    }

    public Entity getEntity() {
        return this.damageEvent.getEntity();
    }
}

