/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.events.lands;

import java.util.Objects;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.kingdoms.abstraction.KingdomItemOperator;
import org.kingdoms.abstraction.PlayerOperator;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.KingdomsEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;

public class NexusMoveEvent
extends KingdomsEvent
implements Cancellable,
PlayerOperator,
KingdomItemOperator {
    private static final HandlerList handlers = new HandlerList();
    private final KingdomPlayer kingdomPlayer;
    private final SimpleLocation from;
    private SimpleLocation to;
    private final Structure structure;
    private Structure newStructure;
    private boolean cancelled;

    public NexusMoveEvent(Structure structure, Structure newStructure, KingdomPlayer kingdomPlayer, SimpleLocation from, SimpleLocation to) {
        this.structure = structure;
        this.newStructure = newStructure;
        this.kingdomPlayer = kingdomPlayer;
        this.from = from;
        this.to = to;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Nullable
    public SimpleLocation getFrom() {
        return this.from;
    }

    public @NonNull SimpleLocation getTo() {
        return this.to;
    }

    public void setTo(@NonNull SimpleLocation to) {
        this.to = Objects.requireNonNull(to);
    }

    @Override
    @Nullable
    public KingdomPlayer getPlayer() {
        return this.kingdomPlayer;
    }

    public @NonNull Structure getNewStructure() {
        return this.newStructure;
    }

    public void setNewStructure(@NonNull Structure newStructure) {
        this.newStructure = Objects.requireNonNull(newStructure);
    }

    @Nullable
    public Structure getKingdomItem() {
        return this.structure;
    }
}

