/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.bedrock;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.ModalForm;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.form.util.FormBuilder;
import org.geysermc.cumulus.util.FormImage;
import org.kingdoms.gui.bedrock.FormType;
import org.kingdoms.gui.bedrock.components.ButtonObject;
import org.kingdoms.gui.bedrock.components.FormComponentObject;
import org.kingdoms.gui.bedrock.components.FormComponentParser;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.provider.MessageBuilder;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/gui/bedrock/FormBuilderObject;", "", "type", "Lorg/kingdoms/gui/bedrock/FormType;", "title", "Lorg/kingdoms/locale/compiler/MessageObject;", "options", "", "", "Lorg/kingdoms/gui/bedrock/components/FormComponentObject;", "iconImageType", "Lorg/geysermc/cumulus/util/FormImage$Type;", "icon", "(Lorg/kingdoms/gui/bedrock/FormType;Lorg/kingdoms/locale/compiler/MessageObject;Ljava/util/Map;Lorg/geysermc/cumulus/util/FormImage$Type;Ljava/lang/String;)V", "build", "Lorg/geysermc/cumulus/form/util/FormBuilder;", "settings", "Lorg/kingdoms/locale/provider/MessageBuilder;", "Companion", "core"})
public final class FormBuilderObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FormType type;
    @NotNull
    private final MessageObject title;
    @NotNull
    private final Map<String, FormComponentObject> options;
    @Nullable
    private final FormImage.Type iconImageType;
    @Nullable
    private final String icon;

    public FormBuilderObject(@NotNull FormType type, @NotNull MessageObject title, @NotNull Map<String, ? extends FormComponentObject> options, @Nullable FormImage.Type iconImageType, @Nullable String icon) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        this.type = type;
        this.title = title;
        this.options = options;
        this.iconImageType = iconImageType;
        this.icon = icon;
    }

    @NotNull
    public final FormBuilder<?, ?, ?> build(@NotNull MessageBuilder settings) {
        FormBuilder formBuilder;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                ModalForm.Builder builder = ModalForm.builder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
                formBuilder = (FormBuilder)builder;
                break;
            }
            case 2: {
                SimpleForm.Builder builder = SimpleForm.builder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
                formBuilder = (FormBuilder)builder;
                break;
            }
            case 3: {
                SimpleForm.Builder builder = SimpleForm.builder();
                Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
                formBuilder = (FormBuilder)builder;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        FormBuilder form = formBuilder;
        form.title(this.title.buildPlain(settings));
        if (form instanceof CustomForm.Builder && this.iconImageType != null && this.icon != null) {
            ((CustomForm.Builder)form).icon(FormImage.of((FormImage.Type)this.iconImageType, (String)this.icon));
        }
        boolean first = true;
        for (Map.Entry<String, FormComponentObject> entry : this.options.entrySet()) {
            String name = entry.getKey();
            FormComponentObject option = entry.getValue();
            if (option instanceof ButtonObject) {
                if (form instanceof SimpleForm.Builder) {
                    ((ButtonObject)option).buildForSimple((SimpleForm.Builder)form, settings);
                    continue;
                }
                if (!(form instanceof ModalForm.Builder)) continue;
                ((ButtonObject)option).buildForModal((ModalForm.Builder)form, settings, first);
                first = false;
                continue;
            }
            if (!(form instanceof CustomForm.Builder)) continue;
            ((CustomForm.Builder)form).component(option.build(settings));
        }
        return form;
    }

    @JvmStatic
    @NotNull
    public static final FormBuilderObject parse(@NotNull ConfigSection config) {
        return Companion.parse(config);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/gui/bedrock/FormBuilderObject$Companion;", "", "()V", "detectImageType", "Lorg/geysermc/cumulus/util/FormImage$Type;", "str", "", "parse", "Lorg/kingdoms/gui/bedrock/FormBuilderObject;", "config", "Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final FormBuilderObject parse(@NotNull ConfigSection config) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            MessageObject title = MessageCompiler.compile(config.getString("title"));
            String string = config.getString("form-type");
            Intrinsics.checkNotNull((Object)string);
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            FormType formType = FormType.valueOf(string2);
            Map options = new HashMap();
            String[] stringArray = new String[]{"form-options"};
            Map<String, ConfigSection> map = config.getSection(stringArray).getSections();
            Intrinsics.checkNotNullExpressionValue(map, (String)"config.getSection(\"form-options\").sections");
            for (Map.Entry<String, ConfigSection> entry : map.entrySet()) {
                String key = entry.getKey();
                ConfigSection section = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                Intrinsics.checkNotNullExpressionValue((Object)section, (String)"section");
                options.put(key, FormComponentParser.Companion.parse(section, formType != FormType.CUSTOM));
            }
            String icon = config.getString("icon");
            FormImage.Type imageType = this.detectImageType(icon);
            Intrinsics.checkNotNullExpressionValue((Object)title, (String)"title");
            return new FormBuilderObject(formType, title, options, imageType, icon);
        }

        @Nullable
        public final FormImage.Type detectImageType(@Nullable String str) {
            if (str == null) {
                return null;
            }
            if (StringsKt.startsWith$default((String)str, (String)"http:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)str, (String)"https:", (boolean)false, (int)2, null)) {
                return FormImage.Type.URL;
            }
            return FormImage.Type.PATH;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormType.values().length];
            nArray[FormType.MODAL.ordinal()] = 1;
            nArray[FormType.SIMPLE.ordinal()] = 2;
            nArray[FormType.CUSTOM.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

