/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.gui.objects;

import com.google.common.base.Enums;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.gui.objects.ConditionalGUIOptionObject;
import org.kingdoms.gui.objects.GUIInteractionType;
import org.kingdoms.gui.objects.GUIOptionBuilder;
import org.kingdoms.gui.objects.GUIOptionObject;
import org.kingdoms.gui.objects.GUIOptionObjectCondition;
import org.kingdoms.gui.objects.inventory.GUIInventoryConstructor;
import org.kingdoms.libs.snakeyaml.exceptions.Mark;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.StringUtils;

public class GUIOptionParser {
    private static final int MAX_X_SLOT = 9;
    private static final int MAX_Y_SLOT = 6;
    private final String name;
    private final ConfigSection root;
    private final ConfigSection config;
    private final String guiName;
    private final GUIInventoryConstructor guiCtor;
    private MessageObject itemTitle;
    private MessageObject[] itemLore;
    private ItemStack item;
    private final ArrayList<GUIOptionObject> parents;
    private final Map<Integer, String> occupiedSlots;
    private static final EnumMap<XMaterial, XMaterial> UNSUPPORTED_FALLBACK = new EnumMap(XMaterial.class);

    public GUIOptionParser(String name, ConfigSection root, ConfigSection config, String guiName, GUIInventoryConstructor guiCtor, Map<Integer, String> occupiedSlots, ArrayList<GUIOptionObject> parents) {
        this.name = name;
        this.config = config;
        this.root = root;
        this.guiName = guiName;
        this.guiCtor = guiCtor;
        this.occupiedSlots = occupiedSlots;
        this.parents = parents;
    }

    public static XMaterial unsupportedMaterial(XMaterial mat) {
        if (mat.isSupported()) {
            return mat;
        }
        return UNSUPPORTED_FALLBACK.getOrDefault((Object)mat, XMaterial.STONE);
    }

    private void deserialize(ConfigSection section) {
        if ("AIR".equals(section.getString("material"))) {
            this.item = new ItemStack(Material.AIR);
            return;
        }
        try {
            ItemStack inheritedItem = this.inherit(x -> x.item);
            this.item = inheritedItem == null ? XItemStack.deserialize(section.toBukkitConfigurationSection(), Function.identity(), new ItemDeserializerRestart(section)) : XItemStack.edit(inheritedItem.clone(), section.toBukkitConfigurationSection(), Function.identity(), new ItemDeserializerRestart(section));
        }
        catch (Exception ex) {
            Mark mark = section.getNode().getStartMark();
            KLogger.error("Failed to parse item for option '" + this.name + "' for GUI " + mark.getName() + ", line " + mark.getLine() + ":\n" + ex.getMessage());
            if (!(ex instanceof XItemStack.MaterialCondition)) {
                ex.printStackTrace();
            }
            this.item = new ItemStack(Material.STONE);
            return;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.addItemFlags(XItemStack.ITEM_FLAGS);
        this.item.setItemMeta(meta);
        this.itemTitle = meta.hasDisplayName() ? MessageCompiler.compile(meta.getDisplayName(), MessageCompiler.defaultSettingsWithErroHandler(exes -> {
            Mark mark = section.getNode().getStartMark();
            KLogger.warn("While parsing display name for '" + this.name + "' option in GUI '" + this.guiName + "', line " + mark.getLine() + ":\n" + exes.joinExceptions());
        })) : this.inherit(x -> x.itemName);
        if (!meta.hasLore()) {
            this.itemLore = this.inherit(x -> x.lore);
            return;
        }
        List lore = meta.getLore();
        this.itemLore = new MessageObject[lore.size()];
        for (int i = 0; i < lore.size(); ++i) {
            MessageObject loreLine;
            int finalI = i + 1;
            this.itemLore[i] = loreLine = MessageCompiler.compile((String)lore.get(i), MessageCompiler.defaultSettingsWithErroHandler(exes -> {
                Mark mark = section.getNode().getStartMark();
                KLogger.warn("While parsing " + StringUtils.toOrdinalNumeral(finalI) + " line of lore for '" + this.name + "' option in GUI '" + this.guiName + "', line " + mark.getLine() + ":\n" + exes.joinExceptions());
            }));
        }
    }

    private static int xyToRawSlot(int x, int y) {
        return y * 9 - (9 - x) - 1;
    }

    public static int[] rawSlotToXY(int slot) {
        return new int[]{slot % 9 + 1, slot / 9 + 1};
    }

    private static int[] toIntArray(List<Integer> integers) {
        int[] ret = new int[integers.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = integers.get(i);
        }
        return ret;
    }

    private ConditionalGUIOptionObject parseConditional(GUIOptionObject parent) {
        ArrayList<GUIOptionObjectCondition> options = new ArrayList<GUIOptionObjectCondition>(10);
        boolean elseOptionFound = false;
        for (Map.Entry<String, ConfigSection> conditionSection : this.config.getSections().entrySet()) {
            ConditionalCompiler.LogicalOperand compiledCondition;
            ConfigSection masterSection;
            block5: {
                masterSection = conditionSection.getValue();
                if (masterSection == null) continue;
                String masterCondition = masterSection.getString("condition");
                if (!Strings.isNullOrEmpty((String)masterCondition)) {
                    if (elseOptionFound) {
                        throw new IllegalStateException("A conditional option found after the else condition '" + this.name + "' option in GUI '" + this.guiName + '\'');
                    }
                    try {
                        compiledCondition = ConditionalCompiler.compile(masterCondition).evaluate();
                        break block5;
                    }
                    catch (Exception ex) {
                        Node node = conditionSection.getValue().getNode("condition");
                        Mark mark = node.getStartMark();
                        KLogger.warn("Failed to parse conditional '" + conditionSection.getKey() + "' for option '" + this.name + "' for GUI " + mark.getName() + ", line " + mark.getLine() + '\n' + ex.getMessage());
                        continue;
                    }
                }
                if (elseOptionFound) continue;
                elseOptionFound = true;
                compiledCondition = null;
            }
            GUIOptionParser childBuilder = new GUIOptionParser(conditionSection.getKey(), this.root, masterSection, this.guiName, this.guiCtor, this.occupiedSlots, this.extendParent(parent));
            options.add(new GUIOptionObjectCondition(compiledCondition, childBuilder.build()));
        }
        return new ConditionalGUIOptionObject(parent, options.toArray(new GUIOptionObjectCondition[0]));
    }

    public ArrayList<GUIOptionObject> extendParent(GUIOptionObject obj) {
        ArrayList newParents = (ArrayList)this.parents.clone();
        newParents.add(obj);
        return newParents;
    }

    public GUIOptionBuilder build() {
        GUIOptionObject main;
        boolean conditional = false;
        String switchStm = this.config.getString("[switch]");
        if (switchStm != null) {
            ConfigSection switchValue = this.root.getSection('[' + switchStm + ']');
            ConditionalCompiler.LogicalVariableOperand fixedVal = new ConditionalCompiler.LogicalVariableOperand(switchStm);
            GUIOptionObject main2 = this.parsePure(this.name, this.config);
            ArrayList<GUIOptionObjectCondition> options = new ArrayList<GUIOptionObjectCondition>(10);
            for (Map.Entry<String, ConfigSection> conditionSection : switchValue.getSections().entrySet()) {
                String caseExpr = conditionSection.getKey();
                ConditionalCompiler.BiLogicalOperator condition = new ConditionalCompiler.BiLogicalOperator(fixedVal, ConditionalCompiler.LogicalOperator.EQUALS, new ConditionalCompiler.StringOperand(caseExpr));
                GUIOptionParser childBuilder = new GUIOptionParser(caseExpr, this.root, conditionSection.getValue(), this.guiName, this.guiCtor, this.occupiedSlots, this.extendParent(main2));
                options.add(new GUIOptionObjectCondition(condition, childBuilder.build()));
            }
            GUIOptionParser childBuilder = new GUIOptionParser("[else]", this.root, switchValue.getSection("[else]"), this.guiName, this.guiCtor, this.occupiedSlots, this.extendParent(main2));
            GUIOptionBuilder built = childBuilder.build();
            options.add(new GUIOptionObjectCondition(null, built));
            return new ConditionalGUIOptionObject(main2, options.toArray(new GUIOptionObjectCondition[0]));
        }
        for (ConfigSection section : this.config.getSections().values()) {
            String masterCondition = section.getString("condition");
            if (Strings.isNullOrEmpty((String)masterCondition)) continue;
            conditional = true;
            break;
        }
        if ((main = this.parsePure(this.name, this.config)) == null) {
            return null;
        }
        if (conditional) {
            return this.parseConditional(main);
        }
        if (XItemStack.isDefaultItem(this.item)) {
            MessageHandler.sendConsolePluginMessage("&4Could not parse item for option: &e" + this.name + " &4in GUI &e" + this.guiName + " &4with properties&8:");
            StringUtils.printConfig(this.config);
            return null;
        }
        return main;
    }

    private boolean validateSlotPositions(int[] slots, boolean conditional) {
        HashSet<Integer> repeated = new HashSet<Integer>(slots.length);
        boolean invalid = false;
        for (int slot : slots) {
            String occupied;
            if (!repeated.add(slot)) {
                MessageHandler.sendConsolePluginMessage("&4Repeated slot position &e" + slot + " &4for option &e" + this.name + " &4in GUI &e" + this.guiName);
                invalid = true;
                continue;
            }
            if (slot < 0) {
                MessageHandler.sendConsolePluginMessage("&4Negative slot position &e" + slot + " &4for option &e" + this.name + " &4in GUI &e" + this.guiName);
                invalid = true;
                continue;
            }
            if (slot > this.guiCtor.getMaxSize()) {
                MessageHandler.sendConsolePluginMessage("&4Slot position &e" + slot + " &4for option &e" + this.name + " &4in GUI &e" + this.guiName + " &4is greater than the allowed slot position in GUI of type &e" + this.guiCtor.getType() + " &4with maximum slots of &e" + this.guiCtor.getMaxSize());
                invalid = true;
                continue;
            }
            if (conditional || (occupied = this.occupiedSlots.get(slot)) == null) continue;
            MessageHandler.sendConsolePluginMessage("&4Duplicated slot position &e" + slot + " &4for option &e" + this.name + " &4in GUI &e" + this.guiName + " &4which is already taken by &e" + occupied + " &4option.");
            invalid = true;
        }
        if (!invalid) {
            Arrays.stream(slots).forEach(s -> this.occupiedSlots.put(s, this.name));
        }
        return invalid;
    }

    private <T> T inherit(Predicate<GUIOptionObject> filter, Function<GUIOptionObject, T> inheritor) {
        ListIterator<GUIOptionObject> backwardsIter = this.parents.listIterator(this.parents.size());
        while (backwardsIter.hasPrevious()) {
            T obj;
            GUIOptionObject parent = backwardsIter.previous();
            if (filter != null && !filter.test(parent) || (obj = inheritor.apply(parent)) == null) continue;
            return obj;
        }
        return null;
    }

    private <T> T inherit(Function<GUIOptionObject, T> inheritor) {
        return this.inherit(null, inheritor);
    }

    public GUIOptionObject parsePure(String name, ConfigSection itemConfig) {
        String message;
        GUIInteractionType interactionType;
        String interactionString;
        XSound.Record sound;
        this.deserialize(itemConfig);
        String itemSound = itemConfig.getString("sound");
        if ("default".equalsIgnoreCase(itemSound)) {
            sound = XSound.parse(KingdomsConfig.GUIS_DEFAULT_CLICK_SOUND.getString());
        } else if (itemSound == null) {
            sound = this.inherit(x -> x.sound);
        } else {
            try {
                sound = XSound.parse(itemSound);
            }
            catch (Exception ex) {
                sound = null;
            }
        }
        List commands = itemConfig.getStringList("commands");
        if (commands.isEmpty()) {
            commands = this.inherit(x -> x.commands);
        }
        if ((interactionString = itemConfig.getString("interaction")) == null) {
            interactionType = this.inherit(x -> x.interactionType);
            if (interactionType == null) {
                interactionType = GUIInteractionType.DISALLOW;
            }
        } else {
            Optional localType = Enums.getIfPresent(GUIInteractionType.class, (String)interactionString);
            if (!localType.isPresent()) {
                Mark mark = itemConfig.getNode("interaction").getStartMark();
                KLogger.warn("While parsing the 'interaction' of " + name + "' option in GUI '" + this.guiName + "', line " + mark.getLine() + ":\nUnknown interaction type: " + interactionString);
            }
            interactionType = (GUIInteractionType)((Object)localType.or((Object)GUIInteractionType.DISALLOW));
        }
        MessageObject compiledMsg = (message = itemConfig.getString("message")) == null ? this.inherit(x -> x.message) : MessageCompiler.compile(message, MessageCompiler.defaultSettingsWithErroHandler(exes -> {
            Mark mark = itemConfig.getNode("message").getStartMark();
            KLogger.warn("While parsing the 'message' of " + name + "' option in GUI '" + this.guiName + "', line " + mark.getLine() + ":\n" + exes.joinExceptions());
        }));
        List<Integer> multiSlots = itemConfig.getIntegerList("slots");
        int[] slots = null;
        if (multiSlots.isEmpty()) {
            ConfigSection slotSection = this.config;
            int itemSlot = slotSection.getInt("slot");
            boolean skip = false;
            if (!slotSection.isSet("slot")) {
                int posX = 0;
                int posY = 0;
                if (slotSection.isSet("posx") && slotSection.isSet("posy")) {
                    posX = slotSection.getInt("posx");
                    posY = slotSection.getInt("posy");
                } else {
                    slots = this.inherit(x -> x.slots);
                    if (slots != null) {
                        skip = true;
                    }
                }
                if (!skip) {
                    if (posX <= 0 || posX > 9) {
                        MessageHandler.sendConsolePluginMessage("&4Invalid GUI X position&8: &e" + posX + " &7- &cMust be between 0 and " + 9);
                        StringUtils.printConfig(slotSection);
                        return null;
                    }
                    if (posY <= 0 || posY > 6) {
                        MessageHandler.sendConsolePluginMessage("&4Invalid GUI Y position&8: &e" + posY + " &7- &cMust be between 0 and " + 6);
                        StringUtils.printConfig(slotSection);
                        return null;
                    }
                    itemSlot = GUIOptionParser.xyToRawSlot(posX, posY);
                }
            }
            if (!skip) {
                slots = new int[]{itemSlot};
            }
        } else {
            slots = GUIOptionParser.toIntArray(multiSlots);
        }
        if (this.validateSlotPositions(slots, !this.parents.isEmpty())) {
            return null;
        }
        return new GUIOptionObject(name, slots, sound, commands, interactionType, this.item, this.itemTitle, this.itemLore, compiledMsg, itemConfig);
    }

    static {
        UNSUPPORTED_FALLBACK.put(XMaterial.LECTERN, XMaterial.CRAFTING_TABLE);
    }

    private final class ItemDeserializerRestart
    implements Consumer<Exception> {
        private final ConfigSection section;

        private ItemDeserializerRestart(ConfigSection section) {
            this.section = section;
        }

        void warn(String cause, String material) {
            KLogger.warn(cause + " '" + material + "' in GUI '" + GUIOptionParser.this.guiName + "' for option '" + GUIOptionParser.this.name + "' " + this.section.getNode("material").getStartMark());
        }

        @Override
        public void accept(Exception exception) {
            if (exception instanceof XItemStack.UnknownMaterialCondition) {
                ((XItemStack.UnknownMaterialCondition)exception).setSolution(XMaterial.STONE);
                return;
            }
            if (exception instanceof XItemStack.UnAcceptableMaterialCondition) {
                XItemStack.UnAcceptableMaterialCondition cond = (XItemStack.UnAcceptableMaterialCondition)exception;
                if (cond.getReason() == XItemStack.UnAcceptableMaterialCondition.Reason.NOT_DISPLAYABLE) {
                    this.warn("Undisplayable material for inventory", ((XItemStack.UnAcceptableMaterialCondition)exception).getMaterial().name());
                    cond.setSolution(XMaterial.STONE);
                } else if (cond.getReason() == XItemStack.UnAcceptableMaterialCondition.Reason.UNSUPPORTED) {
                    cond.setSolution(UNSUPPORTED_FALLBACK.getOrDefault((Object)cond.getMaterial(), XMaterial.STONE));
                }
            }
        }
    }
}

