/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.locale;

import com.google.common.base.Enums;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.config.AdvancedMessage;
import org.kingdoms.config.Comment;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.config.managers.ConfigWatcher;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.libs.snakeyaml.exceptions.Mark;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodePair;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.messages.Titles;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.DefinedMessenger;
import org.kingdoms.locale.provider.AdvancedMessageProvider;
import org.kingdoms.locale.provider.MessageProvider;
import org.kingdoms.locale.provider.NullMessageProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.FSUtil;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.arrays.ArrayUtils;
import org.kingdoms.utils.network.CommitDifference;
import org.kingdoms.utils.network.JSONRequester;

public final class LanguageManager {
    protected static final String LANG_FOLDER_NAME = "languages";
    protected static final String REPO_NAME = "repository";
    private static SupportedLanguage DEFAULT_LANGUAGE = SupportedLanguage.EN;
    public static final Path LANG_FOLDER = Kingdoms.getPath("languages");
    public static final Path REPO_FOLDER = Kingdoms.getPath("repository");
    public static final Path LANGUAGES_REPO_FOLDER = REPO_FOLDER.resolve("languages");
    private static final Map<Class<? extends DefinedMessenger>, DefinedMessenger[]> MESSENGERS = new LinkedHashMap<Class<? extends DefinedMessenger>, DefinedMessenger[]>(1);
    final YamlWithDefaults adapter;
    final SupportedLanguage lang;

    public static <T extends DefinedMessenger> void registerMessenger(Class<T> clazz, T[] values) {
        Objects.requireNonNull(clazz, "Messenger class cannot be null");
        Objects.requireNonNull(values, "Messenger values cannot be null");
        MESSENGERS.put((Class<? extends DefinedMessenger>)clazz, (DefinedMessenger[])values);
    }

    public static <T extends Enum<?>> void registerMessenger(Class<T> clazz) {
        Objects.requireNonNull(clazz, "Messenger class cannot be null");
        Enum[] constants = Objects.requireNonNull((Enum[])clazz.getEnumConstants(), "The provided class is not an enum. Consider using registerMessenger(Class, T[]) instead.");
        MESSENGERS.put(clazz, (DefinedMessenger[])constants);
    }

    public static void uninstall(SupportedLanguage lang) {
        KLogger.info("Uninstalling " + (Object)((Object)lang));
        lang.getAdapter().getFile().delete();
        lang.uninstall();
        FSUtil.deleteFolder(lang.getRepoPath());
        FSUtil.deleteFolder(GUIConfig.getFolder().resolve(lang.getLowerCaseName()));
    }

    public static void install(SupportedLanguage lang) throws IOException {
        LanguageManager.install(lang, null);
    }

    public static void install(SupportedLanguage lang, Consumer<String> guiDownloaded) throws IOException {
        String name = lang.getLowerCaseName();
        Path repoFolder = REPO_FOLDER.resolve(LANG_FOLDER_NAME).resolve(name);
        KLogger.info("Downloading language files for " + name);
        ArrayList<String> notFound = new ArrayList<String>(20);
        String downloadFrom = "resources/languages/" + name + '/' + name + ".yml";
        boolean res = JSONRequester.downloadGitHubFile(downloadFrom, repoFolder.resolve(name + ".yml"));
        if (!res) {
            notFound.add(downloadFrom);
        }
        Path mainGUIDir = repoFolder.resolve("guis");
        for (String gui : SupportedLanguage.EN.getGUIs().keySet()) {
            downloadFrom = "resources/languages/" + name + "/guis/" + gui + ".yml";
            res = JSONRequester.downloadGitHubFile(downloadFrom, mainGUIDir.resolve(gui + ".yml"));
            if (!res) {
                notFound.add(downloadFrom);
            }
            guiDownloaded.accept(downloadFrom);
        }
        if (!notFound.isEmpty()) {
            KLogger.warn("Couldn't find the following files for " + name + " language, this is normal: " + notFound);
        }
        LanguageManager.setCommitSHA(lang, JSONRequester.getMasterSHA());
        LanguageManager.load(lang);
        GUIConfig.registerGUIsFor(lang);
        ConfigWatcher.registerGUIWatchers(lang);
        KingdomsCommandHandler.reload();
    }

    public static void update(SupportedLanguage lang, CommitDifference difference) throws IOException {
        String name = lang.getLowerCaseName();
        Path repoFolder = REPO_FOLDER.resolve(LANG_FOLDER_NAME).resolve(name);
        for (String fileName : difference.getFiles()) {
            Path path = repoFolder.resolve(fileName);
            try {
                JSONRequester.downloadGitHubFile("resources/languages/" + name + '/' + fileName, path);
            }
            catch (IOException ex) {
                KLogger.error("Failed to update " + name + " language:");
                ex.printStackTrace();
            }
        }
        LanguageManager.setCommitSHA(lang, JSONRequester.getMasterSHA());
    }

    public static void setCommitSHA(SupportedLanguage lang, String commitSHA) {
        lang.setInstalledCommitSHA(commitSHA);
        ConfigManager.getGlobals().set(new String[]{"updates", LANG_FOLDER_NAME, lang.getLowerCaseName()}, (Object)commitSHA);
        ConfigManager.getGlobalsAdapter().saveConfig();
    }

    private LanguageManager(SupportedLanguage lang) {
        this.lang = lang;
        ConfigSection commitShaConfigs = ConfigManager.getGlobals().createSection("updates", LANG_FOLDER_NAME);
        Path langRepoPath = lang.getRepoPath();
        if (lang == SupportedLanguage.EN || Files.exists(langRepoPath, new LinkOption[0]) && !FSUtil.isFolderEmpty(langRepoPath)) {
            if (lang != SupportedLanguage.EN && !commitShaConfigs.isSet(lang.getLowerCaseName())) {
                KLogger.warn("Couldn't find the language version for " + lang.getLowerCaseName() + " but it's in the repository folder.\nThis means that you manually installed the language yourself or modified globals.yml file.\nThe plugin will automatically fix this for you.");
                commitShaConfigs.set(lang.getLowerCaseName(), (Object)JSONRequester.getMasterSHA());
                ConfigManager.getGlobalsAdapter().saveConfig();
            }
            lang.initialize();
            if (lang != SupportedLanguage.EN) {
                lang.setInstalledCommitSHA(commitShaConfigs.getString(lang.getLowerCaseName()));
            }
            KLogger.info("Loading language: " + (Object)((Object)lang) + " (version " + lang.getInstalledCommitSHA() + ')');
        } else if (commitShaConfigs.isSet(lang.getLowerCaseName())) {
            KLogger.warn("The plugin found version information about " + lang.getLowerCaseName() + " installed language, however the files couldn't be found.\nThis means that you manually uninstalled it by removing folders from 'repository' folder of the plugin.\nThe plugin will automatically fix this for you.");
            commitShaConfigs.set(lang.getLowerCaseName(), null);
            ConfigManager.getGlobalsAdapter().saveConfig();
            this.adapter = null;
            return;
        }
        this.adapter = lang.isInstalled() ? lang.getAdapter() : null;
    }

    public static SupportedLanguage getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public static SupportedLanguage localeOf(CommandSender sender) {
        return sender instanceof Player ? LanguageManager.localeOf((Player)sender) : LanguageManager.getDefaultLanguage();
    }

    public static SupportedLanguage localeOf(OfflinePlayer sender) {
        return sender == null ? LanguageManager.getDefaultLanguage() : KingdomPlayer.getKingdomPlayer(sender).getLanguage();
    }

    public static SupportedLanguage localeOf(Player sender) {
        return LanguageManager.localeOf((OfflinePlayer)sender);
    }

    public void load() {
        if (this.adapter == null) {
            return;
        }
        try {
            Files.createDirectories(LANG_FOLDER, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.adapter.getFile().exists()) {
            if (this.lang == SupportedLanguage.EN) {
                this.adapter.createEmptyConfigIfNull();
                this.loadEnglishDefaults();
                this.adapter.saveConfig();
            } else {
                this.adapter.saveDefaultConfig();
            }
            this.adapter.reload();
        } else {
            this.adapter.load();
        }
        if (this.adapter.getConfig() != null) {
            new EntryLoader();
        }
    }

    public static void load(SupportedLanguage lang) {
        try {
            new LanguageManager(lang).load();
        }
        catch (Exception ex) {
            KLogger.error("An exception has occurred while loading main language file for: " + lang.name());
            ex.printStackTrace();
        }
    }

    private static void loadDefaultLanguage() {
        SupportedLanguage lang = SupportedLanguage.fromName(KingdomsConfig.LANG.getString());
        if (lang == null) {
            KLogger.error("Unknown language '" + KingdomsConfig.LANG.getString() + "' switching to English.");
            lang = SupportedLanguage.EN;
        }
        if (!lang.isInstalled()) {
            KLogger.error("You cannot use " + (Object)((Object)lang) + " language as the default language because it's not installed.");
            lang = SupportedLanguage.EN;
        }
        DEFAULT_LANGUAGE = lang;
        KLogger.info("Default language: " + lang.name() + " (" + lang.getNativeName() + ')');
    }

    public static void loadAll() {
        try {
            LanguageManager.loadAll0();
        }
        catch (IOException e) {
            KLogger.error("Failed to load language files:");
            e.printStackTrace();
        }
        LanguageManager.addRepositoryInfo();
        LanguageManager.loadDefaultLanguage();
    }

    static void addRepositoryInfo() {
        if (!Files.exists(REPO_FOLDER, new LinkOption[0])) {
            return;
        }
        try {
            Files.write(REPO_FOLDER.resolve("README.txt"), Arrays.asList("The repository folder is a reference folder meant for read-only purposes.", "You shouldn't add, delete or modify any of the files.", "This is the folder used to generate back language files if they", "are deleted without having to redownload them. If you want to uninstall a certain", "language, simply do it from '/k admin languagepacks' command in-game instead."), StandardCharsets.US_ASCII, new OpenOption[0]);
        }
        catch (IOException e) {
            KLogger.error("Failed to add info file to libs folder:");
            e.printStackTrace();
        }
    }

    static void loadAll0() throws IOException {
        if (Files.exists(LANG_FOLDER, new LinkOption[0])) {
            try (Stream<Path> walker = Files.walk(LANG_FOLDER, new FileVisitOption[0]);){
                walker.forEach(langName -> {
                    if (langName.equals(LANG_FOLDER)) {
                        return;
                    }
                    String name = langName.getFileName().toString();
                    name = name.substring(0, name.length() - 4);
                    LanguageManager.getLanguageOrWarn(name);
                });
            }
        }
        for (SupportedLanguage lang : SupportedLanguage.VALUES) {
            LanguageManager.load(lang);
        }
    }

    public static SupportedLanguage getLanguageOrWarn(String name) {
        SupportedLanguage lang = (SupportedLanguage)((Object)Enums.getIfPresent(SupportedLanguage.class, (String)name.toUpperCase(Locale.ENGLISH)).orNull());
        if (lang == null) {
            KLogger.error("Unknown language found in 'languages' folder: " + name);
            KLogger.error("It's either named incorrectly or not built into the plugin. In order to add a new language to the plugin you need to contact the developer with the necessary files.");
        }
        return lang;
    }

    private void putDefault(DefinedMessenger lang) {
        MessageProvider defaultProvider;
        String errors;
        MessageObject obj;
        String def = lang.getDefaultValue();
        MessageCompiler compiler = def == null ? null : new MessageCompiler(def);
        MessageObject messageObject = obj = compiler == null ? null : compiler.compileObject();
        if (compiler != null && compiler.hasErrors() && !(errors = compiler.joinExceptions()).contains("macro")) {
            throw new AssertionError((Object)("Default message contains error for " + lang.name() + '\n' + errors));
        }
        AdvancedMessage data = lang.getAdvancedData();
        if (data == null) {
            defaultProvider = new MessageProvider(obj);
        } else {
            MessageObject actionbar;
            MessageObject messageObject2 = actionbar = data.actionbar().isEmpty() ? null : new MessageCompiler(data.actionbar()).compileObject();
            Titles titles = !data.title().isEmpty() || !data.subtitle().isEmpty() ? new Titles(data.title().isEmpty() ? null : data.title(), data.subtitle().isEmpty() ? null : data.subtitle(), 10, 40, 10) : null;
            AdvancedMessageProvider extra = new AdvancedMessageProvider(obj, actionbar, titles);
            if (data.sound() != AdvancedMessage.DEFAULT_SOUND) {
                extra.withSound(new XSound.Record(data.sound()));
            }
            defaultProvider = extra;
        }
        this.lang.addMessage(lang, defaultProvider);
    }

    private void saveDefault(DefinedMessenger lang) {
        Node keyNode;
        ConfigSection config = this.adapter.getConfig();
        String def = lang.getDefaultValue();
        Comment comments = lang.getComment();
        AdvancedMessage data = lang.getAdvancedData();
        if (data != null) {
            ConfigSection section = config.createSection(lang.getLanguageEntry().getPath());
            keyNode = section.getNode();
            if (def != null) {
                section.set("message", (Object)def);
            }
            if (data.sound() != AdvancedMessage.DEFAULT_SOUND) {
                section.set("sound", (Object)data.sound().name());
            }
            if (!data.actionbar().isEmpty()) {
                section.set("actionbar", (Object)data.actionbar());
            }
            if (!data.title().isEmpty() || !data.subtitle().isEmpty()) {
                if (!data.title().isEmpty()) {
                    section.set(new String[]{"titles", "title"}, (Object)data.title());
                }
                if (!data.subtitle().isEmpty()) {
                    section.set(new String[]{"titles", "subtitle"}, (Object)data.subtitle());
                }
            }
        } else {
            Pair<ConfigSection, NodePair> section = config.createSection(lang.getLanguageEntry().getPath(), (Object)def);
            keyNode = comments != null && comments.forParent() ? section.getKey().getKey() : section.getValue().getKey();
        }
        if (comments != null) {
            keyNode.setSimpleComments(comments.value());
        }
    }

    private MessageObject parseMessage(String msg, Node node, String[] path) {
        MessageCompiler compiler = new MessageCompiler(msg);
        MessageObject obj = compiler.compileObject();
        if (compiler.hasErrors()) {
            Mark mark = node.getWholeMark();
            KLogger.warn("An error occurred while parsing message for '" + String.join((CharSequence)".", path) + "' in " + this.adapter.getFile() + " at line " + mark.getLine() + ":\n" + mark.createSnippet(0, Integer.MAX_VALUE, "", null).trim() + '\n' + compiler.joinExceptions());
        }
        return obj;
    }

    private void loadEnglishDefaults() {
        for (DefinedMessenger[] vals : MESSENGERS.values()) {
            for (DefinedMessenger lang : vals) {
                this.putDefault(lang);
                this.saveDefault(lang);
            }
        }
    }

    public static String getRawMessage(DefinedMessenger lang, SupportedLanguage locale) {
        ConfigSection config = locale.getAdapter().getConfig();
        Node foundSection = config.findNode(lang.getLanguageEntry().getPath());
        if (foundSection == null) {
            return null;
        }
        if (foundSection.getNodeType() == NodeType.MAPPING) {
            ConfigSection section = new ConfigSection(null, (MappingNode)foundSection);
            return section.getString("message");
        }
        return NodeInterpreter.STRING.parse(foundSection);
    }

    static {
        LanguageManager.registerMessenger(KingdomsLang.class, (DefinedMessenger[])KingdomsLang.VALUES);
    }

    private final class EntryLoader {
        final ConfigSection config;
        final Set<DefinedMessenger> remainingEntries;
        final Map<LanguageEntry, DefinedMessenger> definedEntries;

        private EntryLoader() {
            this.config = LanguageManager.this.adapter.getConfig();
            this.remainingEntries = Collections.newSetFromMap(new IdentityHashMap(KingdomsLang.VALUES.length + 300));
            this.definedEntries = new HashMap<LanguageEntry, DefinedMessenger>(KingdomsLang.VALUES.length + 300);
            Iterator<Object> iterator = MESSENGERS.values().iterator();
            while (iterator.hasNext()) {
                DefinedMessenger[] vals;
                for (DefinedMessenger lang : vals = (DefinedMessenger[])iterator.next()) {
                    this.definedEntries.put(lang.getLanguageEntry(), lang);
                    this.remainingEntries.add(lang);
                }
            }
            this.loadEntries(null, this.config);
            if (!this.remainingEntries.isEmpty()) {
                for (DefinedMessenger remainingEntry : this.remainingEntries) {
                    String[] path = remainingEntry.getLanguageEntry().getPath();
                    Node foundSection = this.config.findNode(path);
                    if (foundSection != null) continue;
                    LanguageManager.this.saveDefault(remainingEntry);
                    LanguageManager.this.putDefault(remainingEntry);
                }
                KLogger.debug((DebugNS)KingdomsDebug.LANGUAGE_MISSING$ENTRIES, () -> "Added missing enteries to " + LanguageManager.this.lang.name() + ": " + this.remainingEntries.stream().map(x -> String.join((CharSequence)" -> ", x.getLanguageEntry().getPath())).collect(Collectors.joining(" | ")));
                LanguageManager.this.adapter.saveConfig();
            }
        }

        private void loadEntries(String[] currentEntryRoot, ConfigSection root) {
            for (String key : root.getKeys()) {
                MessageProvider provider;
                String[] currentEntry = currentEntryRoot;
                currentEntry = currentEntry == null ? new String[]{key} : ArrayUtils.merge(currentEntry, new String[]{key});
                LanguageEntry entry = new LanguageEntry(currentEntry);
                DefinedMessenger defined = this.definedEntries.get(entry);
                Node node = root.getNode(key);
                if (defined == null) {
                    if (node.getNodeType() == NodeType.MAPPING) {
                        MappingNode mapping = (MappingNode)node;
                        this.loadEntries(currentEntry, new ConfigSection(mapping));
                        continue;
                    }
                } else {
                    this.remainingEntries.remove(defined);
                }
                if (node.getNodeType() == NodeType.MAPPING) {
                    ConfigSection section = new ConfigSection(null, (MappingNode)node);
                    provider = new AdvancedMessageProvider(section);
                } else {
                    String msg = NodeInterpreter.STRING.parse(node);
                    if (msg != null) {
                        MessageObject obj = LanguageManager.this.parseMessage(msg, node, currentEntry);
                        provider = new MessageProvider(obj);
                    } else {
                        provider = NullMessageProvider.getInstance();
                    }
                }
                LanguageManager.this.lang.getMessages().put(entry, provider);
            }
        }
    }
}

